% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_emoji.R
\name{download_emoji}
\alias{download_emoji}
\title{Scraping a dictionary of emoji from Emojipedia.org}
\usage{
download_emoji(
  pages = c("https://emojipedia.org/people/", "https://emojipedia.org/nature/",
    "https://emojipedia.org/food-drink/", "https://emojipedia.org/activity/",
    "https://emojipedia.org/travel-places/", "https://emojipedia.org/objects/",
    "https://emojipedia.org/symbols/", "https://emojipedia.org/flags/"),
  skinpages = c("https://emojipedia.org/light-skin-tone/",
    "https://emojipedia.org/medium-light-skin-tone/",
    "https://emojipedia.org/medium-skin-tone/",
    "https://emojipedia.org/medium-dark-skin-tone/",
    "https://emojipedia.org/dark-skin-tone/"),
  regular_xpath = "/html/body/div[5]/div[1]/ul",
  skinpages_xpath = "/html/body/div[5]/div[1]/article/section[1]/ul",
  exception_xpath = "/html/body/div[5]/div[1]/article/section[1]/ul[2]"
)
}
\arguments{
\item{pages}{A character vector containing the URLs of the emoji categories you want to fetch, e.g.\href{https://emojipedia.org/people/}{https://emojipedia.org/people/}}

\item{skinpages}{A character vector containing the URLs of the skintone modifier categories you want to fetch, e.g. \href{https://emojipedia.org/medium-skin-tone/}{https://emojipedia.org/medium-skin-tone/}}

\item{regular_xpath}{Xpath of the html table containing the emoji information, e.g. '/html/body/div[5]/div[1]/ul'}

\item{skinpages_xpath}{Xpath of the html table containing the skintone modifier information, e.g. '/html/body/div[5]/div[1]/article/section[1]/ul'}

\item{exception_xpath}{Xpath of the html table containing the skintone modifier information specifically for Fitzpatrick 1-2, e.g. '/html/body/div[5]/div[1]/article/section[1]/ul[2]'}
}
\value{
A data frame containing:\cr
     1) The native representation of all emoji in R \cr
     2) A textual description of what the emoji is displaying \cr
     3) Original order of the HTML table that the emojis were fetched from
}
\description{
Scrapes a dictionary of emoji from \href{https://www.emojipedia.org/}{emojipedia}, assuming that the website is available and its structure does not change.
Can be used to update the emoji dictionary contained in this package by replacing the file and recompiling the package. The dictionary is ordered according to the length of
the emojis' byte representation (longer ones first) to prevent partial matching of shorter strings when iterating
through the data frame.
}
\examples{
Emoji_dictionary <- download_emoji(pages = c("https://emojipedia.org/activity/"))
}
