% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly_wblr.R
\name{plotly_wblr}
\alias{plotly_wblr}
\title{Interactive Probability Plot.}
\usage{
plotly_wblr(
  wblr_obj,
  susp = NULL,
  suspplot = NULL,
  restab = NULL,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  col = NULL,
  signif = NULL,
  grid = NULL,
  gridcol = NULL,
  intcol = NULL
)
}
\arguments{
\item{wblr_obj}{An object of class 'wblr'.}

\item{susp}{An optional numeric vector of suspension data.}

\item{suspplot}{Show the suspensions plot (TRUE) or not (FALSE).}

\item{restab}{Show the results table (TRUE) or not (FALSE).}

\item{main}{Main title.}

\item{xlab}{X-axis label.}

\item{ylab}{Y-axis label.}

\item{col}{Color of the model fit and confidence bounds}

\item{signif}{Significant digits of results}

\item{grid}{Show grid (TRUE) or hide grid (FALSE).}

\item{gridcol}{Color of the grid.}

\item{intcol}{Color of the intervals for interval censored models.}
}
\value{
The function returns no value.
}
\description{
Interactive Probability Plot.
}
\examples{
library(WeibullR)
library(WeibullR.plotly)
failures<-c(30, 49, 82, 90, 96)
obj<-wblr.conf(wblr.fit(wblr(failures)))
plotly_wblr(obj)
}
