% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/max_detect.R
\name{max_detect}
\alias{max_detect}
\title{Detect and filter out all maxima in a signal}
\usage{
max_detect(data = NULL, pts)
}
\arguments{
\item{data}{Matrix or data frame with the first column being depth or time
and the second column being a proxy}

\item{pts}{The pts parameter specifies how many points to the left/right up/down the peak detect algorithm goes in detecting
a peak. The peak detecting algorithm works by comparing the values left/right up/down of it, if the values are both higher or lower
then the value a peak. To deal with error produced by this algorithm the pts parameter can be changed which can
aid in peak detection. Usually increasing the pts parameter means more peak certainty, however it also means that minor peaks might not be
picked up by the algorithm \code{Default=3}}
}
\value{
#Returns a matrix with 2 columns
first column is depth/time
the second column are local maxima values
}
\description{
The \code{\link{max_detect}} function is used
to detect and filter out local maxima in a sinusoidal signal.
}
\examples{
#Example in which the ~210yr de Vries cycle is extracted from the Total Solar
#Irradiance data set of Steinhilber et al., (2012)
#after which all maxima are extracted

TSI_wt <-
analyze_wavelet(
data = TSI,
dj = 1/200,
lowerPeriod = 16,
upperPeriod = 8192,
   verbose = FALSE,
   omega_nr = 6
 )

de_Vries_cycle <- extract_signal_stable(wavelet=TSI_wt,
cycle=210,
period_up =1.25,
period_down = 0.75,
add_mean=TRUE,
plot_residual=FALSE)


min_de_Vries_cycle <- min_detect(de_Vries_cycle)

}
