% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hilbert_transform.R
\name{Hilbert_transform}
\alias{Hilbert_transform}
\title{Perform a Hilbert transform on a signal}
\usage{
Hilbert_transform(data = NULL, demean = TRUE, nr_pad = 100)
}
\arguments{
\item{data}{Input is a time series with the first column being depth or time and the second column being a proxy.}

\item{demean}{Remove the mean from the time series.}

\item{nr_pad}{nr of points added tot the top and bottom of the data set
to mitigate the edging effect of the Hilbert transform.}
}
\value{
Returns a matrix with 2 columns.
The first column is depth/time.
The second column is the Hilbert transform of the signal.
}
\description{
Extract the amplitude modulation using the Hilbert transform.
}
\examples{
#Example in which the Hilbert transform (eg. amplitude modulation) of the ~210yr
#de Vries cycle is extracted from the Total Solar Irradiance data set of
#Steinhilber et al., (2012)

#Perform the CWT
TSI_wt <-
analyze_wavelet(
data = TSI,
dj = 1/200,
lowerPeriod = 16,
upperPeriod = 8192,
   verbose = FALSE,
   omega_nr = 6
 )

#Extract the 210 yr de Vries cycle from the wavelet spectra
de_Vries_cycle <- extract_signal_stable(wavelet=TSI_wt,
cycle=210,
period_up =1.25,
period_down = 0.75,
add_mean=TRUE,
plot_residual=FALSE)

#Perform the Hilbert transform on the amplitude record of the 210 yr de Vries
# cycle which was extracted from the wavelet spectra

de_Vries_cycle_hilbert <- Hilbert_transform(data=de_Vries_cycle,demean=TRUE)

}
\references{
Wouters, S., Crucifix, M., Sinnesael, M., Da Silva, A.C., Zeeden, C., Zivanovic, M., Boulvain, F.,
Devleeschouwer, X., 2022, "A decomposition approach to cyclostratigraphic signal processing".
Earth-Science Reviews 225 (103894). <doi:10.1016/j.earscirev.2021.103894>

Huang, Norden E., Zhaohua Wu, Steven R. Long, Kenneth C. Arnold, Xianyao Chen, and Karin Blank. 2009.
"On Instantaneous Frequency". Advances in Adaptive Data Analysis 01 (02): 177–229. <doi:10.1142/S1793536909000096>
}
\author{
Based on the the \link[DecomposeR]{inst.pulse} function of the 'DecomposeR' R package.
}
