% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AddValues.R
\name{AddValues}
\alias{AddValues}
\title{AddValues}
\usage{
AddValues(server, username, password, site, variable, methodID, sourceID,
  qualityControl, values)
}
\arguments{
\item{server}{The URL of the web service ending with /services or with ?wsdl,
for example: http://worldwater.byu.edu/app/index.php/default/services/cuahsi_1_1.asmx?wsdl
alternatively you can specify the JSON API url like:
http://worldwater.byu.edu/app/index.php/default/services/api/}

\item{username}{The valid HydroServer Lite username, for example "admin"}

\item{password}{The valid HydroServer Lite password, for example "password"}

\item{site}{The valid SiteID}

\item{variable}{The valid VariableID}

\item{methodID}{The valid MethodID}

\item{sourceID}{The valid SourceID}

\item{qualityControl}{The valid QualityControlLevelID}

\item{values}{The valid table of data values. This table must have the following columns:
Time (POSIXct), DataValue (numeric).}
}
\value{
Status (the status showing if the values were added: OK or Error). If the status is Error, then
the Error message with reason why the values could not be added is also shown.
}
\description{
This function adds a table of data values to HydroServer Lite.
The input must be a data.frame with Time and DataValue fields
The Time field must be POSIXct format and DataValue must be numeric format
it is also required to enter a valid SiteID, VariableID, SourceID, MethodID and
QualityControlLevelID. New data values shall be inserted only if the SiteID, VariableID,
SourceID, MethodID and QualityControlLevelID entries already exist in the HydroServer.
NOTE: this only works with HydroServer Lite that implements the JSON API.
you must specify a valid server url, user name, and password for the HydroServer.
The examples here use the 'sandbox' HydroServer on http://worldwater.byu.edu/app/
with the username: admin and password: password.
}
\examples{
user <- "admin"
pass <- "password"
server <- "http://worldwater.byu.edu/app/index.php/default/services/cuahsi_1_1.asmx"
sourceID = 15
qualityID = 1
variableID = 43
siteID = 170
methodID = 10
random_times <- sort(Sys.time() + runif(3, 0, 10)*60)
random_values <- runif(3, 0, 100)
my_values <- data.frame(Time=random_times, DataValue=random_values)

status  <- AddValues(server, username=user, password=pass,
                     site=siteID, variable=variableID,
                     methodID=methodID, sourceID=sourceID,
                     qualityControl=qualityID, values=my_values)
}
\keyword{WaterML}

