% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WL.R
\name{Firth_WL}
\alias{Firth_WL}
\alias{Firth_WL_log}
\title{Firth's method for bias correction of estimators}
\usage{
Firth_WL(y, init)

Firth_WL_log(y, init)
}
\arguments{
\item{y}{a numeric vector.}

\item{init}{a vector of initial values for iterative algorithm designed
to solve the modified likelihood equations.}
}
\value{
A vector of corrected estimators lambda and phi.
}
\description{
Firth's method is bias correction option included in \code{WL}. \code{Firth_WL} and \code{Firth_WL_log} provides
the bias corrected lambda and phi based on Firth's method.
}
\details{
\code{Firth_WL} and \code{Firth_WL_log} returns a vector of estimates of parameters corrected by Firth's method
which uses the modified likelihood equations. In case of weighted Lindley distribution,
two non-linear equations should be solved since the solutions are not in closed form.
To this end, R package \code{nleqslv} is used.
To avoid poor local maxima, other estimators like MMEm or MLEc are recommended
to be used as initial values.
}
\section{Background}{

Non-linear equations to be solved are derived in Kim and Jang (2020).
}

\examples{
data <- fail_fiber
Firth_WL(data,MMEm_WL(data))
Firth_WL_log(data,MMEm_WL(data))

}
\references{
Hyoung-Moon Kim. and Yu-Hyeong Jang. (2020). New Closed-Form Estimators for
Weighted Lindley Distribution. \emph{ }, submitted.
}
