% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculator_f.R
\name{qcond_norm}
\alias{qcond_norm}
\title{Conditional quantile function for normal distribution}
\usage{
qcond_norm(rnd = 0.5, mean, sd, lower_bound = 0, s_obs)
}
\arguments{
\item{rnd}{Vector of quantiles}

\item{mean}{The mean parameter}

\item{sd}{The sd parameter}

\item{lower_bound}{The lower bound to be used (current time)}

\item{s_obs}{is the survival observed up to lower_bound time,
normally defined from time 0 as 1 - pnorm(q = lower_bound, mean, sd) but may be different if parametrization has changed previously}
}
\value{
Estimate(s) from the conditional normal distribution based on given parameters
}
\description{
Conditional quantile function for normal distribution
}
\examples{
qcond_norm(rnd = 0.5, mean = 1,sd = 1,lower_bound = 1, s_obs=0.8)
}
