% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_f.R
\name{add_tte}
\alias{add_tte}
\title{Define events and the initial event time}
\usage{
add_tte(.data = NULL, arm, evts, other_inp = NULL, input)
}
\arguments{
\item{.data}{Existing data for initial event times}

\item{arm}{The intervention for which the events and initial event times are defined}

\item{evts}{A vector of the names of the events}

\item{other_inp}{A vector of other input variables that should be saved during the simulation}

\item{input}{The definition of initial event times for the events listed in the evts argument}
}
\value{
A list of initial events and event times
}
\description{
Define events and the initial event time
}
\details{
Events need to be separately defined for each intervention.

For each event that is defined in this list, the user needs to add a reaction to the event using the \code{add_reactevt()} function which will determine what calculations will happen at an event.
}
\examples{
add_tte(arm="int",evts = c("start","ttot","idfs","os"),
input={
start <- 0
idfs <- draw_tte(1,'lnorm',coef1=2, coef2=0.5)
ttot <- min(draw_tte(1,'lnorm',coef1=1, coef2=4),idfs)
os <- draw_tte(1,'lnorm',coef1=0.8, coef2=0.2)
})

}
