% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{computeGamma1}
\alias{computeGamma1}
\title{Internal function: Compute model-averaged estimator of focus regressors in walsNB}
\usage{
computeGamma1(
  gamma2,
  Z2start,
  Z2,
  U,
  V,
  singularVals,
  ellStart,
  gStart,
  epsilonStart,
  qStart,
  y0Start,
  tStart,
  psiStart
)
}
\arguments{
\item{gamma2}{Model-averaged estimate for auxiliary regressors
from \code{\link[WALS]{computePosterior}}.}

\item{Z2start}{Transformed design matrix of auxiliary regressors \eqn{\bar{Z}_2}.
See details.}

\item{Z2}{Another transformed design matrix of auxiliary regressors \eqn{Z_2}.
See details.}

\item{U}{Left singular vectors of \eqn{\bar{Z}_1} from \code{\link[base]{svd}}.}

\item{V}{Right singular vectors of \eqn{\bar{Z}_1} from \code{\link[base]{svd}}.}

\item{singularVals}{Singular values of \eqn{\bar{Z}_1} from \code{\link[base]{svd}}.}

\item{ellStart}{Vector \eqn{\bar{\ell}} see details.}

\item{gStart}{Derivative of dispersion parameter \eqn{\rho} of NB2 with
respect to \eqn{\alpha = \log(\rho)} evaluated at starting values of
one-step ML. \code{gStart} is a scalar.
See section "ML estimation" of  \insertCite{huynhwalsnb;textual}{WALS}.}

\item{epsilonStart}{Scalar \eqn{\bar{\epsilon}}, see section
"One-step ML estimator" of \insertCite{huynhwalsnb;textual}{WALS} for definition.}

\item{qStart}{Vector \eqn{\bar{q}}, see section "One-step ML estimator" of
\insertCite{huynhwalsnb;textual}{WALS} for definition.}

\item{y0Start}{Vector \eqn{\bar{y}_0}, see section "One-step ML estimator" of
\insertCite{huynhwalsnb;textual}{WALS} for definition.}

\item{tStart}{Scalar \eqn{\bar{t}}, see section "One-step ML estimator" of
\insertCite{huynhwalsnb;textual}{WALS} for definition.}

\item{psiStart}{Diagonal matrix \eqn{\bar{\Psi}}, see section
"One-step ML estimator" of \insertCite{huynhwalsnb;textual}{WALS} for definition.}
}
\description{
Exploits the SVD of the design matrix of the focus regressors \eqn{\bar{Z}_1},
the model-averaged estimator for the auxiliary regressors
\eqn{\hat{\gamma}_{2}} and the Sherman-Morrison-Woodbury
formula for computing the model-averaged estimator of the focus regressors
in walsNB.
}
\details{
See section "Simplification for computing \eqn{\hat{\gamma}_{1}}"
in the appendix of \insertCite{huynhwals;textual}{WALS} for details of the
implementation and for the definitions of argument \code{ellStart}.

All parameters that contain "start" feature the starting values for the
one-step ML estimation of submodels. See section "One-step ML estimator" of
\insertCite{huynhwalsnb;textual}{WALS} for details.

The argument \code{Z2start} is defined as
(see section "Transformed model" in \insertCite{huynhwalsnb;textual}{WALS})

\deqn{
\bar{Z}_{2} := \bar{X}_{2} \bar{\Delta}_{2} \bar{\Xi}^{-1/2},
}

and \code{Z2} is defined as

\deqn{
Z_{2} := X_{2} \bar{\Delta}_{2} \bar{\Xi}^{-1/2}.
}

Uses \code{\link[WALS]{svdLSplus}} under-the-hood.
}
\references{
\insertAllCited{}
}
