% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optparse_helper.R
\name{optparse_parameters}
\alias{optparse_parameters}
\title{optparse_parameters - parse easily the command line parameters}
\usage{
optparse_parameters(
  fix_hyphens = TRUE,
  fix_dots = TRUE,
  add_trailing_hyphens = TRUE,
  args = NULL,
  no_optparse = FALSE,
  ...
)
}
\arguments{
\item{fix_hyphens}{logical - whether to turn underscores into hyphens or not}

\item{fix_dots}{logical - whether to turn points into hyphens or not}

\item{add_trailing_hyphens}{logical - whether to add trailing hyphens
if missing}

\item{args}{\code{list} - The parameters from the \code{commandArgs} function}

\item{no_optparse}{logical - INTERNAL Tells whether to use optparse library or not}

\item{...}{parameters definition. Must be the result of either those functions:
\itemize{
\item optparse_flag
\item optparse_numeric
\item optparse_integer
\item optparse_character
\item optparse_list
}}
}
\description{
This function is made to be used with the functions optparse_flag,
optparse_numeric, optparse_integer, optparse_character and/or
optparse_list

\code{optparse_parameters} parses arguments based on its parameters.

You just have to call \code{optparse_parameters} with named arguments.
Each parameter is the result of either optparse_flag, optparse_numeric,
optparse_integer, optparse_character or optparse_list
}
\examples{

args <- optparse_parameters(
  a_integer = optparse_integer(),
  a_float = optparse_numeric(),
  a_boolean = optparse_flag(),
  a_character = optparse_character(),
  a_list = optparse_list(of = "numeric"),
  a_char_list = optparse_list(of = "character"),
  a_int_list = optparse_list(of = "integer"),
  args = list(
    "--a-integer",
    "42",
    "--a-float",
    "3.14",
    "--a-boolean",
    "FALSE",
    "--a-character",
    "FALSE",
    "--a-list",
    "1.5,2,3",
    "--a-char-list",
    "1.5,2,3",
    "--a-int-list",
    "1.5,2,3"
  )
)

str(args)

}
\author{
L.Pavot
}
