% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ph2simon_etc.R
\name{Sprintf.ph2simon}
\alias{Sprintf.ph2simon}
\title{Short Paragraph to Describe a \link[clinfun]{ph2simon} Object}
\usage{
Sprintf.ph2simon(model, type = c("minimax", "optimal", "n1", "maximax"), ...)
}
\arguments{
\item{model}{\link[clinfun]{ph2simon} object}

\item{type}{\link[base]{character} scalar, type of Simon's two-stage design,
\describe{
\item{\code{'minimax'}}{(default) minimum total sample size}
\item{\code{'optimal'}}{minimum expected total sample size \emph{under \eqn{p_0}}}
\item{\code{'n1'}}{minimum Stage-1 sample size}
\item{\code{'maximax'}}{maximum total sample size (as provided by end-user)}
}}

\item{...}{additional parameters, currently not in use}
}
\value{
\link{Sprintf.ph2simon} returns a \link[base]{noquote} \link[base]{character} scalar.
}
\description{
To create a short paragraph to describe a \link[clinfun]{ph2simon} object.
}
\examples{
library(clinfun)
(x = ph2simon(pu = .2, pa = .4, ep1 = .05, ep2 = .1)) 
Sprintf.ph2simon(x, type = 'minimax')
Sprintf.ph2simon(x, type = 'optimal')
Sprintf.ph2simon(x, type = 'n1')
Sprintf.ph2simon(x, type = 'maximax')

}
