% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-metadata.R
\name{geom_col_name}
\alias{geom_col_name}
\alias{feature_cols}
\alias{get_col_df}
\title{Get Column Information}
\usage{
geom_col_name(x)

feature_cols(x)

get_col_df(x)
}
\arguments{
\item{x}{object of class \code{vicmap_promise}}
}
\value{
character/data.frame
}
\description{
\code{geom_col_name} returns a single value for the name of the geometry column for the
WFS layer selected in the \code{vicmap_promise} object (e.g. \code{SHAPE}). This column will become the \code{geometry} column
when using \code{collect()}. \code{feature_cols()} provides a vector of all column names for the WFS layer selected in the
\code{vicmap_promise} object and  \code{get_col_df()} returns a data.frame with the column names and their XML schema string
datatypes.
}
\examples{
\donttest{
# Return the name of the geometry column
vicmap_query(layer = "datavic:VMHYDRO_WATERCOURSE_DRAIN") \%>\% 
  geom_col_name()
 }
\donttest{
# Return the column names as a character vector
vicmap_query(layer = "datavic:VMHYDRO_WATERCOURSE_DRAIN") \%>\% 
  feature_cols()
}   
\donttest{
# Return a data.frame of the columns and their XML schema string datatypes
vicmap_query(layer = "datavic:VMHYDRO_WATERCOURSE_DRAIN") \%>\% 
  get_col_df()
 }
}
