% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modarithmeticop.R
\name{08. Modular-arithmetic}
\alias{08. Modular-arithmetic}
\alias{summod}
\alias{summod.default}
\alias{summod.numeric}
\alias{summod.vli}
\alias{submod}
\alias{submod.default}
\alias{submod.numeric}
\alias{submod.vli}
\alias{mulmod}
\alias{mulmod.default}
\alias{mulmod.numeric}
\alias{mulmod.vli}
\alias{powmod}
\alias{powmod.default}
\alias{powmod.numeric}
\alias{powmod.vli}
\alias{invmod}
\alias{invmod.default}
\alias{invmod.numeric}
\alias{invmod.vli}
\alias{divmod}
\alias{divmod.default}
\alias{divmod.numeric}
\alias{divmod.vli}
\title{Basic Modular-Arithmetic Operators for vli Objects}
\usage{
summod(x, y, mod)

\method{summod}{default}(x, y, mod)

\method{summod}{numeric}(x, y, mod)

\method{summod}{vli}(x, y, mod)

submod(x, y, mod)

\method{submod}{default}(x, y, mod)

\method{submod}{numeric}(x, y, mod)

\method{submod}{vli}(x, y, mod)

mulmod(x, y, mod)

\method{mulmod}{default}(x, y, mod)

\method{mulmod}{numeric}(x, y, mod)

\method{mulmod}{vli}(x, y, mod)

powmod(x, n, mod)

\method{powmod}{default}(x, n, mod)

\method{powmod}{numeric}(x, n, mod)

\method{powmod}{vli}(x, n, mod)

invmod(x, n)

\method{invmod}{default}(x, n)

\method{invmod}{numeric}(x, n)

\method{invmod}{vli}(x, n)

divmod(x, y, mod)

\method{divmod}{default}(x, y, mod)

\method{divmod}{numeric}(x, y, mod)

\method{divmod}{vli}(x, y, mod)
}
\arguments{
\item{x}{vli class object or 32 bits integer}

\item{y}{vli class object or 32 bits integer}

\item{mod}{vli class object or 32 bits integer}

\item{n}{vli class object or 32 bits integer}
}
\value{
object of class vli
}
\description{
Basic modular-arithmetic operators for vli (Very Large Integers) objects.
}
\details{
The functions \code{summod}, \code{submod} and \code{mulmod} compute respectively the sum, the substraction and the multiplication of \code{x} and \code{y} under modulo \code{mod}.

The function \code{powmod} computes the \code{n}-th power of \code{x} under modulo \code{mod}.

The function \code{invmod} returns the modular multiplicative inverse of \code{x} in Z\code{n}; that is,  \code{y = x^(-1)} such that \code{ x * y = 1 (}mod\code{ n)}.

The function \code{divmod} returns the modular division of \code{x} over \code{y}; that is, \code{z} such that \code{y * z (}mod \code{mod) = x (}mod \code{mod)}.
}
\examples{
x <- as.vli("8925378246957826904701")
y <- as.vli("347892325634785693")
mod <- as.vli(21341)

summod(x, y, mod)

mulmod(x, invmod(x, n = 123), mod = 123) == 1

z <- divmod(x, y, mod)
mulmod(z, y, mod) == x \%\% mod
}
\author{
Javier Leiva Cuadrado
}
