% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_XAJ.R
\docType{data}
\name{XAJ.param.range}
\alias{XAJ.param.range}
\title{XAJ parameters}
\format{
An object of class \code{data.frame} with 15 rows and 4 columns.
}
\usage{
XAJ.param.range
}
\description{
The lumped XAJ model has 13 parameters, including:
\itemize{
\item If \code{full.UH = FALSE}:
}

The parameter \code{params} must be a numeric vector looks like:
\code{c(KC, IM, WUM, WLM, WDM, C, B, SM, EX, KI, KG, CI, CG, N, NK)}
\itemize{
\item If \code{full.UH = TRUE}:
}

when use the instantaneous unit hydrograph of Nash, or looks like:
\code{c(KC, IM, WUM, WLM, WDM, C, B, SM, EX, KI, KG, CI, CG, UH_1, UH_2, ..., UH_n)}
UH_1, UH_2, ..., UH_n means the series of the unit hydrograph.
}
\details{
\subsection{Parameters:}{
\enumerate{
\item \code{KC}  : Ratio of potential evap to pan evap
\item \code{IM}  : Fraction of impermeable area
\item \code{WUM} : Soil moisture capacity of upper layer
\item \code{WLM} : Soil moisture capacity of lower layer
\item \code{WDM} : Soil moisture capacity of deep layer
\item \code{C}   : Coefficient of deep evap
\item \code{B}   : Exponent of the soil moisture storage capacity curve
\item \code{SM}  : Areal mean free water capacity of the surface soil layer
\item \code{EX}  : Exponent of the free water capacity curve
\item \code{KI}  : outflow coefficients of the free water storage to interflow
\item \code{KG}  : outflow coefficients of the free water storage to groundwater
\item \code{CI}  : recession constant of the lower interflow storage
\item \code{CG}  : recession constant of groundwater storage.
\item \code{N}: (optional) number of reservoirs in the instantaneous unit hydrograph \cr
\item \code{NK}: (optional) common storage coefficient in the instantaneous unit hydrograph \cr
}

\strong{If \code{full.UH = TRUE}: 14~end: is the full unit hydrograph defined by user.}
}
}
\keyword{datasets}
