\name{usagrain}
\alias{usagrain}
\docType{data}
\title{USA Grain Prices Data}
\description{
A 4-column matrix.

}
\usage{data(usagrain)}
\format{
  The columns are:
  \describe{
    \item{wheat.flour}{numeric}
    \item{corn}{numeric}
    \item{wheat}{numeric}
    \item{rye}{numeric}
  }
}
\details{
Monthly averages of grain prices
in the United States for wheat flour, corn, wheat, and rye for the
period January 1961 through October 1972.
The units are US dollars per 100 pound sack for wheat flour, and
per bushel for corn, wheat and rye.
}
\source{
Ahn and Reinsel (1988) 
}
\references{
Ahn, S. K  and Reinsel, G. C. (1988)
Nested reduced-rank autoregressive models for multiple time series.
\emph{Journal of the American Statistical Association}, 
\bold{83}, 849--856.
}
\examples{
cgrain = scale(usagrain, scale=FALSE)   # Center the time series only
fit = vglm(cgrain ~ 1, rrar(Rank=c(4,1)),
           eps=1e-3, step=0.5, trace=TRUE, maxit=40)
summary(fit)
}
\keyword{datasets}

