% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{as.matrix.VCAinference}
\alias{as.matrix.VCAinference}
\title{Standard 'as.matrix' Method for 'VCAinference' S3-Objects}
\usage{
\method{as.matrix}{VCAinference}(x, what = c("VC", "SD", "CV"), digits = 6,
  ...)
}
\arguments{
\item{x}{(VCAinference) object}

\item{what}{(character) one or multiple choices from "VC" (variance component), "SD" (standard deviation) or
"CV" (coefficient of variation)}

\item{digits}{(integer) number of decimal digits to be used}

\item{...}{additional arguments to be passed to or from methods.}
}
\value{
(matrix) with point estimates, one- and two-sided confidence intervals and variances
of the estimated variance components
}
\description{
This function makes use of the hidden feature of function \code{\link{print.VCAinference}} which invisibly returns character 
matrices of estimated variance components expressed as "VC" (variance component), "SD" (standard deviation) or "CV" (coefficient
of variation). If argument "what" is not specified, a named list will be returned with all three matrices.
}
\examples{
\dontrun{
data(dataEP05A2_1)
fit <- anovaVCA(y~day/run, dataEP05A2_1)
inf <- VCAinference(fit, VarVC=TRUE)
as.matrix(inf, what="VC", digits=6)
as.matrix(inf, what="SD", digits=6)
as.matrix(inf, what="CV", digits=2)

# request list of matrices
as.matrix(inf)
}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
\seealso{
\code{\link{print.VCAinference}}, \code{\link{as.matrix.VCA}}
}

