% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unbmom2.R
\name{uM2pow2pool}
\alias{uM2pow2pool}
\title{Pooled central moment estimates - two-sample}
\usage{
uM2pow2pool(m2, m4, n_x, n_y)
}
\arguments{
\item{m2}{naive biased variance estimate \eqn{m_2 = 1/(n_x + n_y) \sum_{i =
1}^{n_x} ((X_i - \bar{X})^2 + \sum_{i = 1}^{n_y} ((Y_i - \bar{Y})^2}{m[2] =
mean(c((X - X-bar)^2, (Y - Y-bar)^2))} for vectors \code{X} and \code{Y}.}

\item{m4}{naive biased fourth central moment estimate \eqn{m_4 = 1/(n_x +
n_y) \sum_{i = 1}^{n_x} ((X_i - \bar{X})^4 + \sum_{i = 1}^{n_y} ((Y_i -
\bar{Y})^4}{m[4] = mean(c((X - X-bar)^4, (Y - Y-bar)^4))} for vectors
\code{X} and \code{Y}.}

\item{n_x}{number of observations in the first group.}

\item{n_y}{number of observations in the second group.}
}
\value{
Pooled estimate of squared variance \eqn{\mu_2^2}{\mu[2]^2}, where
  \eqn{\mu_2}{\mu[2]} is a variance.
}
\description{
Calculate pooled unbiased estimates of central moments and their powers and
products.
}
\examples{
nx <- 10
ny <- 8
shp <- 3
smpx <- rgamma(nx, shape = shp) - shp
smpy <- rgamma(ny, shape = shp)
mx <- mean(smpx)
my <- mean(smpy)
m  <- numeric(4)
for (j in 2:4) {
  m[j] <- mean(c((smpx - mx)^j, (smpy - my)^j))
}
uM2pow2pool(m[2], m[4], nx, ny)
}
\seealso{
Other pooled estimates (two-sample): \code{\link{uM2M3pool}},
  \code{\link{uM2M4pool}}, \code{\link{uM2pool}},
  \code{\link{uM2pow3pool}}, \code{\link{uM3pool}},
  \code{\link{uM3pow2pool}}, \code{\link{uM4pool}},
  \code{\link{uM5pool}}, \code{\link{uM6pool}}
}
\concept{pooled estimates (two-sample)}
