% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UBStats_Main_Visible_ALL_202406.R
\name{TEST.prop}
\alias{TEST.prop}
\title{Test on the proportion}
\usage{
TEST.prop(
  x,
  success = NULL,
  p0 = 0.5,
  alternative = "two.sided",
  digits = 2,
  force.digits = FALSE,
  use.scientific = FALSE,
  data,
  ...
)
}
\arguments{
\item{x}{An unquoted string identifying the variable of interest.
\code{x} can be the name of a vector
or a factor in the workspace or the name of one of the columns in the
data frame specified in the \code{data} argument.}

\item{success}{If \code{x} is a factor, a character vector, or a numeric
non-binary vector, \code{success} must be used to indicate the category/value
corresponding to success. The argument can be omitted (\code{NULL},
default) if \code{x} is a binary numeric vector (takes values 0 or 1 only;
in this case success is assumed to be 1) or a logical vector (in these
cases success is assumed to be \code{TRUE}).}

\item{p0}{Numeric value that specifies the null hypothesis to test for
(default is 0).}

\item{alternative}{A length-one character vector specifying the direction
of the alternative hypothesis. Allowed values are \code{"two.sided"}
(population proportion differs from \code{p0}; default), or \code{"less"}
(population proportion is lower than \code{p0}), or \code{"greater"}
(population proportion is higher than \code{p0}).}

\item{digits}{Integer value specifying the number of
decimals used to round statistics; default to 2. If the chosen rounding formats some
non-zero values as zero, the number of decimals is increased
so that all values have at least one significant digit, unless the argument
\code{force.digits} is set to \code{TRUE}.}

\item{force.digits}{Logical value indicating whether reported values
should be forcedly rounded to the number of decimals specified in
\code{digits} even if non-zero values are
rounded to zero (default to \code{FALSE}).}

\item{use.scientific}{Logical value indicating whether numbers
in tables should be displayed using
scientific notation (\code{TRUE}); default to \code{FALSE}.}

\item{data}{An optional data frame containing \code{x}.
If not found in \code{data}, \code{x} is taken from the environment
from which \code{TEST.prop()} is called.}

\item{...}{Additional arguments to be passed to low level functions.}
}
\value{
A table reporting the results of the test on the population
proportion of successes.
}
\description{
\code{TEST.prop()}  tests hypotheses on the proportion of successes in a
population.
}
\examples{
data(MktDATA, package = "UBStats")

# Success = one value of a character vector or factor
# - Bilateral test
TEST.prop(WouldSuggest, success = "Yes", p0 = 0.7, 
         data = MktDATA)
# - Unilateral test, change digits
TEST.prop(Education, success = "Post-Grad", p0 = 0.3, 
          alternative = "less", digits = 4,data = MktDATA)

# Success = numeric value; bilateral test
TEST.prop(Children, success = 2, p0 = 0.3, data = MktDATA)

# Binary variable (success = 1 by default); unilateral
TEST.prop(LastCampaign, p0 = 0.1, alternative = "greater", 
          digits = 3, data = MktDATA)

# Logical variable (success = TRUE by default); unilateral test
TEST.prop(Deals.ge50, p0 = 0.13, alternative = "greater", 
          digits = 3, data = MktDATA)

# Success based on combined conditions
# - Build a (logical) vector 
IsTop <- MktDATA$CustClass == "Gold" |
  MktDATA$CustClass == "Platinum"
TEST.prop(IsTop, p0 = 0.2, data = MktDATA)

HighAOV <- MktDATA$AOV>150
TEST.prop(HighAOV, p0 = 0.1)
TEST.prop(HighAOV, p0 = 0.1, force.digits = TRUE)
TEST.prop(HighAOV, p0 = 0.1, use.scientific = TRUE)

# Output results
out_test_prop<-TEST.prop(IsTop, p0 = 0.2, data = MktDATA)

}
\seealso{
\code{\link{CI.prop}()} to build confidence intervals for the
population proportion of successes.
}
\author{
Raffaella Piccarreta \email{raffaella.piccarreta@unibocconi.it}
}
