% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ELEFAN_GA.R
\name{ELEFAN_GA}
\alias{ELEFAN_GA}
\title{ELEFAN_GA}
\usage{
ELEFAN_GA(
  lfq,
  seasonalised = FALSE,
  low_par = NULL,
  up_par = NULL,
  popSize = 50,
  maxiter = 100,
  run = maxiter,
  parallel = FALSE,
  pmutation = 0.1,
  pcrossover = 0.8,
  elitism = base::max(1, round(popSize * 0.05)),
  MA = 5,
  addl.sqrt = FALSE,
  agemax = NULL,
  flagging.out = TRUE,
  seed = NULL,
  monitor = FALSE,
  plot = FALSE,
  plot.score = TRUE,
  ...
)
}
\arguments{
\item{lfq}{a list consisting of following parameters:
\itemize{
  \item \strong{midLengths} midpoints of the length classes,
  \item \strong{dates} dates of sampling times (class Date),
  \item \strong{catch} matrix with catches/counts per length class (row)
     and sampling date (column);
}}

\item{seasonalised}{logical; indicating if the seasonalised von Bertalanffy
growth function should be applied (default: FALSE).}

\item{low_par}{a list providing the minimum of the search space in case
of real-valued or permutation encoded optimizations. When set to NULL the
following default values are used:
 \itemize{
  \item \strong{Linf} length infinity in cm (default is calculated from maximum
  length class in the data),
  \item \strong{K} curving coefficient (default: 0.01),
  \item \strong{t_anchor} time point anchoring growth curves in year-length
  coordinate system, corrsponds to peak spawning month (range: 0 to 1, default: 0),
  \item \strong{C} amplitude of growth oscillation (range: 0 to 1, default: 0),
  \item \strong{ts} summer point (ts = WP - 0.5) (range: 0 to 1, default: 0);
}}

\item{up_par}{a list providing the maximum of the search space in case of
real-valued or permutation encoded optimizations. When set to NULL the
following default values are used:
 \itemize{
  \item \strong{Linf} length infinity in cm (default is calculated from maximum
  length class in the data),
  \item \strong{K} curving coefficient (default: 1),
  \item \strong{t_anchor} time point anchoring growth curves in year-length
  coordinate system, corrsponds to peak spawning month (range: 0 to 1, default: 1),
  \item \strong{C} amplitude of growth oscillation (range: 0 to 1, default: 1),
  \item \strong{ts} summer point (ts = WP - 0.5) (range: 0 to 1, default: 1);
}}

\item{popSize}{the population size. Default: 50}

\item{maxiter}{the maximum number of iterations to run before the
GA search is halted. default:100}

\item{run}{the number of consecutive generations without any improvement
in the best fitness value before the GA is stopped. Default: equals maxiter}

\item{parallel}{a logical argument specifying if parallel computing
should be used (TRUE) or not (FALSE, default) for evaluating the
fitness function. See \code{\link[GA]{ga}} for details. Default:FALSE, but
setting to TRUE may substantially improve required calculation time. Use of
this functionality requires the following packages: parallel, doParallel.}

\item{pmutation}{the probability of mutation in a parent chromosome.
Usually mutation occurs with a small probability, and by default is set to 0.1.}

\item{pcrossover}{the probability of crossover between pairs of chromosomes.
Typically this is a large value and by default is set to 0.8.}

\item{elitism}{the number of best fitness individuals to survive at each generation.
By default the top 5\% individuals will survive at each iteration.}

\item{MA}{number indicating over how many length classes the moving average
should be performed (default: 5, for
   more information see \link{lfqRestructure})}

\item{addl.sqrt}{additional squareroot transformation of positive values
according to Brey et al. (1988) (default: FALSE, for
   more information see \link{lfqRestructure})}

\item{agemax}{maximum age of species; default NULL, then estimated from Linf}

\item{flagging.out}{logical; should positive peaks be flagged out? Original setting of
ELEFAN in TRUE. Default:TRUE}

\item{seed}{an integer value containing the random number generator state. This
argument can be used to replicate the results of a GA search. Note that
if parallel computing is required, the doRNG package must be installed.
(Default: 'seed = NULL')}

\item{monitor}{a logical or an R function which takes as input the current
state of the 'ga-class' object and show the evolution of the
search. By default, 'monitor = FALSE' so any
output is suppressed. Possible also, the functions
'gaMonitor' or 'gaMonitor2' (depending on whether or not is
an RStudio session) which print the average and best fitness
values at each iteration. If set to 'plot' these information
are plotted on a graphical device. Other functions can be
written by the user and supplied as argument.}

\item{plot}{logical; Plot restructured counts with fitted lines using
\code{\link{plot.lfq}} and \code{\link{lfqFitCurves}} (default : FALSE).}

\item{plot.score}{logical; Plot genetic algorithm fitness progression.
(Default: plot.score=TRUE).}

\item{...}{additional parameters to pass to \code{\link[GA]{ga}}}
}
\value{
A list with the input parameters and following list objects:
\itemize{
  \item \strong{samplingPeriod}: length of sampling period in years,
  \item \strong{samplingDays}: time of sampling times in relation to first sampling time,
  \item \strong{delta_t}: array with time differences between relative sampling time set to zero and
     other sampling times,
  \item \strong{rcounts}: restructured frequencies,
  \item \strong{peaks_mat}: matrix with positive peaks with distinct values,
  \item \strong{ASP}: available sum of peaks, sum of posititve peaks which could be
     potential be hit by
     growth curves,
  \item \strong{ncohort}: maximum age of species,
  \item \strong{agemax}: maximum age of species,
  \item \strong{par}: a list with the parameters of the von Bertalanffy growth
     function:
     \itemize{
       \item \strong{Linf}: length infinity in cm,
       \item \strong{K}: curving coefficient;
       \item \strong{t_anchor}: time point anchoring growth curves in year-length
         coordinate system, corrsponds to peak spawning month,
       \item \strong{C}: amplitude of growth oscillation
         (if \code{seasonalised} = TRUE),
       \item \strong{ts}: summer point of oscillation (ts = WP - 0.5)
         (if \code{seasonalised} = TRUE),
       \item \strong{phiL}: growth performance index defined as
         phiL = log10(K) + 2 * log10(Linf);
     }
  \item \strong{Rn_max}: highest value of fitness function, (comparable with ELEFAN and ELEFAN_SA).
}
}
\description{
Electronic LEngth Frequency ANalysis with genetic algorithm
used for estimating growth parameters.
}
\details{
A more detailed description of the generic algorithm (GA) can be found in
   Scrucca (2013). The score value \code{fitnessValue} is not comparable with
   the score value of the other ELEFAN functions (\code{\link{ELEFAN}} or
   \code{\link{ELEFAN_SA}}).
}
\examples{
\donttest{
# load data and view catch length frequencies
data(synLFQ4)
plot(synLFQ4, Fname="catch")

# Genetic algorithm
# (if using a multicore processor,
#   consider adding the argument 'parallel=TRUE'
#   to reduce computation time)
output <- ELEFAN_GA(synLFQ4, seasonalised = TRUE,
   low_par = list(Linf = 70, K = 0.25, t_anchor = 0, C = 0, ts= 0),
   up_par = list(Linf = 90, K = 0.7, t_anchor = 1, C = 1, ts = 1),
   popSize = 40, maxiter = 50, run = 20,
   MA = 11, plot = TRUE, seed = 1111)
output$par
output$ASP
output$Rn_max

# compare fitness score (fESP) to
# that calculated with "true" growth parameter values
plot(output, draw = FALSE)
lfqFitCurves(output, par=list(Linf=80, K=0.5, t_anchor=0.25, C=0.75, ts=0.5),
       draw = TRUE, col=1, flagging.out = FALSE)$fESP
lfqFitCurves(output, par=output$par, draw = TRUE, col=2, flagging.out = FALSE)$fESP
legend("top", legend=c("orig.", "GA"), lty=2, col=1:2, ncol=2)
}

}
\references{
Brey, T., Soriano, M., and Pauly, D. 1988. Electronic length frequency analysis: a
   revised and expanded
user's guide to ELEFAN 0, 1 and 2.

Pauly, D. and N. David, 1981. ELEFAN I, a BASIC program for the objective extraction of
growth parameters from length-frequency data. \emph{Meeresforschung}, 28(4):205-211

Scrucca, L. (2013). GA: a package for genetic algorithms in R. Journal of
Statistical Software, 53(4), 1-37.
}
