#' @name synLFQ6
#'
#' @title Synthetic length-frequency data VI (without seasonal oscillation)
#'
#'
#' @description Synthetic length-frequency data as generated by the function
#' \code{lfqGen} from the \emph{fishdynr} package (Taylor 2016). Can be used by
#' \code{\link[TropFishR]{ELEFAN}} or \code{\link[TropFishR]{ELEFAN_SA}}.
#' The data is generated with the following von Bertalanffy growth parameters:
#' \itemize{
#'   \item K = 0.47
#'   \item Linf = 33.7
#'   \item C = 0
#'   \item ts = 0
#'   \item t_anchor = 0.25 (Time when yearly recruitment pulse occurs;
#'   e.g. 0 = Jan 1, 0.25 = Apr 1, 0.5 = Jul 1st, 0.75 = Oct 1)
#' }
#'
#' Further settings include:
#' \itemize{
#'   \item L50 = 10 (length at 50\% prob. of capture via trawl net)
#'   \item wqs = 3 (width between 25\% and 75\% prob. of capture quantiles;
#'   i.e. wqs = 0 is knife-edge selection)
#'   \item M = 0.8 (Natural mortality rate)
#'   \item harvest_rate = 1.3 (Fishing mortality rate)
#' }
#'
#' @docType data
#'
#' @format A list of class lfq consisting of:
#' \itemize{
#'   \item \strong{dates} dates of sampling times (class Date),
#'   \item \strong{midLengths} midpoints of the length classes,
#'   \item \strong{catch} matrix with catches/counts per length class (row) and
#'      sampling date (column).
#' }
#'
#' @source Taylor, M (2016). fishdynr: Fisheries science related population dynamics
#' models. R package version 0.2. https://github.com/marchtaylor/fishdynr
#'
#' @usage data(synLFQ6)
#' @keywords data dataset length-frequency
#'
#' @examples
#' data(synLFQ6)
#'
#' # plot of length frequencies
#' plot(synLFQ6, Fname = "catch")
#'
#' # plot of restructured length frequencies
#' synLFQ6 <- lfqRestructure(synLFQ6, MA = 7)
#' plot(synLFQ6, Fname = "rcounts")
#'
#'
#'
NULL
