% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TriadSim_functions.R
\name{get.target.geno}
\alias{get.target.geno}
\title{Getting genotypes of the target SNPs}
\usage{
get.target.geno(input.plink.file, target.snp, snp.all2)
}
\arguments{
\item{input.plink.file}{is a vector of three character strings for the file names of the mother's
father's and child's plink base filenames with the necessary path to the directory. The plink files are in bed format and three files with 
extensions .bed .bim and .fam are expected for each individual's genotypes. The mothers, fathers, and 
childredn must be from the same set of trio families even though the ordering of the families can be different
for the three sets of data.}

\item{target.snp}{is a vector of integers showing the row number of the target SNPs in the .bim file}

\item{snp.all2}{is a dataframe containing list of SNPs in PLINK .bim format. Only the second column is used which contains
the rs number of the SNPs. The colname name of the second column has to be "V2".}
}
\value{
A list of three matrices is returned. The three matrices are the observed genotypes of the mothers from family 1 to family n repeated twice,
genotypes of the fathers from family 1 to family n repeated twice and genotypes of children from family 1 to n followed by (stacking on top of) 
genotypes of the complements at the target SNPs.
}
\description{
This function read out the genotypes of the selected target SNPs from the orignal data set (the data set on
which simulation is based).
}
\examples{
tar.snp <- c(21, 118, 121, 140, 155, 168, 218, 383) 
m.file <- file.path(system.file(package = "TriadSim"),'extdata/pop1_4chr_mom')
f.file <- file.path(system.file(package = "TriadSim"),'extdata/pop1_4chr_dad')
k.file <- file.path(system.file(package = "TriadSim"),'extdata/pop1_4chr_kid')
# the preloaded data frame snp.all2 contains the data frame read from the corresponding .bim file.
\dontrun{ 
target.geno <- get.target.geno(c(m.file,f.file,k.file), tar.snp,snp.all2)
}
}
