% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_properties.R
\name{NTip}
\alias{NTip}
\alias{NTip.default}
\alias{NTip.Splits}
\alias{NTip.list}
\alias{NTip.phylo}
\alias{NTip.multiPhylo}
\alias{NTip.phyDat}
\alias{NTip.matrix}
\title{Number of leaves in a phylogenetic tree}
\usage{
NTip(phy)

\method{NTip}{default}(phy)

\method{NTip}{Splits}(phy)

\method{NTip}{list}(phy)

\method{NTip}{phylo}(phy)

\method{NTip}{multiPhylo}(phy)

\method{NTip}{phyDat}(phy)

\method{NTip}{matrix}(phy)
}
\arguments{
\item{phy}{Object representing one or more phylogenetic trees.}
}
\value{
\code{NTip()} returns an integer specifying the number of tips in each
object in \code{phy}.
}
\description{
\code{NTip()} extends \code{\link[ape:summary.phylo]{ape::Ntip()}} to handle
objects of class \code{Splits} and \code{list}, and edge matrices
(equivalent to \code{tree$edge}).
}
\seealso{
Other tree properties: 
\code{\link{ConsensusWithout}()},
\code{\link{NSplits}()},
\code{\link{PathLengths}()},
\code{\link{SplitsInBinaryTree}()},
\code{\link{TipLabels}()},
\code{\link{TreeIsRooted}()}

Other Splits operations: 
\code{\link{LabelSplits}()},
\code{\link{NSplits}()},
\code{\link{PolarizeSplits}()},
\code{\link{SplitFrequency}()},
\code{\link{SplitsInBinaryTree}()},
\code{\link{Splits}},
\code{\link{TipLabels}()},
\code{\link{TipsInSplits}()},
\code{\link{match.Splits}},
\code{\link{xor}()}
}
\concept{Splits operations}
\concept{tree properties}
