% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArtificialExtinction.R
\name{ArtificialExtinction}
\alias{ArtificialExtinction}
\alias{ArtificialExtinction.matrix}
\alias{ArtificialExtinction.phyDat}
\alias{ArtEx}
\title{Artificial Extinction}
\usage{
ArtificialExtinction(
  dataset,
  subject,
  template,
  replaceAmbiguous = "ambig",
  replaceCoded = "original",
  sampleFrom = NULL
)

\method{ArtificialExtinction}{matrix}(
  dataset,
  subject,
  template,
  replaceAmbiguous = "ambig",
  replaceCoded = "original",
  sampleFrom = NULL
)

\method{ArtificialExtinction}{phyDat}(
  dataset,
  subject,
  template,
  replaceAmbiguous = "ambig",
  replaceCoded = "original",
  sampleFrom = NULL
)

ArtEx(
  dataset,
  subject,
  template,
  replaceAmbiguous = "ambig",
  replaceCoded = "original",
  sampleFrom = NULL
)
}
\arguments{
\item{dataset}{Phylogenetic dataset of class \code{phyDat} or \code{matrix}.}

\item{subject}{Vector identifying subject taxa, by name or index.}

\item{template}{Character or integer identifying taxon to use as a template.}

\item{replaceAmbiguous, replaceCoded}{Character specifying whether tokens
that are ambiguous (\verb{?}) or coded (not \verb{?}) in the fossil template should
be replaced with:
\itemize{
\item \code{original}: Their original value; i.e. no change;
\item \code{ambiguous}: The ambiguous token, \verb{?};
\item \code{binary}: The tokens \code{0} or \code{1}, with equal probability;
\item \code{uniform}: One of the tokens present in \code{sampleFrom}, with equal
probability;
\item \code{sample}: One of the tokens present in \code{sampleFrom}, sampled according
to their frequency.
}}

\item{sampleFrom}{Vector identifying a subset of characters from which to
sample replacement tokens.
If \code{NULL}, replacement tokens will be sampled from the initial states of
all taxa not used as a template (including the subjects).}
}
\value{
A dataset with the same class as \code{dataset} in which entries that
are ambiguous in \code{template} are made ambiguous in \code{subject}.
}
\description{
Remove tokens that do not occur in a fossil 'template' taxon from a living
taxon, to simulate the process of fossilization in removing data from
a phylogenetic dataset.
}
\details{
Note: this simple implementation does not account for character contingency,
e.g. characters whose absence imposes inapplicable or absent tokens on
dependent characters.
}
\examples{
set.seed(1)
dataset <- matrix(c(sample(0:2, 4 * 8, TRUE),
                    '0', '0', rep('?', 6)), nrow = 5,
                    dimnames = list(c(LETTERS[1:4], 'FOSSIL'),
                                    paste('char', 1:8)), byrow = TRUE)
artex <- ArtificialExtinction(dataset, c('A', 'C'), 'FOSSIL')
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
