% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IWScore.R, R/pp_ProfileScore.R
\name{IWScoreMorphy}
\alias{IWScoreMorphy}
\alias{ProfileScore}
\alias{ProfileScoreMorphy}
\alias{ProfileInitMorphy}
\alias{ProfileDestroyMorphy}
\title{Profile Parsimony Score}
\usage{
IWScoreMorphy(parent, child, dataset, concavity = 4,
  minSteps = attr(dataset, "min.steps"), ...)

ProfileScore(tree, dataset)

ProfileScoreMorphy(parent, child, dataset, ...)

ProfileInitMorphy(dataset)

ProfileDestroyMorphy(dataset)
}
\arguments{
\item{parent}{the first column of the edge matrix of a tree of class \code{\link{phylo}}, i.e. tree$edge[, 1]}

\item{child}{the second column of the edge matrix of a tree of class \code{\link{phylo}}, i.e. tree$edge[, 2]}

\item{dataset}{Dataset of class \code{phyDat}.  The dataset should have been
prepared using \code{dataset <- \link{PrepareDataProfile}(dataset)};
if this step has not been completed, the dataset will be (time-consumingly)
prepared within the function.
In subsidiary functions, the dataset will have been initialized using 
\code{ProfileInitMorphy}, must be destroyed using \code{ProfileDestroyMorphy}.}

\item{concavity}{A numeric value to use as the concavity constant (`k`) in implied weighting.}

\item{minSteps}{Integer vector specifying the minimum number of steps
possible for each character in `dataset`, perhaps calculated
using \code{\link{MinimumSteps}}.}

\item{\dots}{unused; allows additional parameters specified within \dots to be 
received by the function without throwing an error.}

\item{tree}{A tree of class \code{\link{phylo}}.}
}
\value{
Zero minus the profile score (because the optimization algorithm 
treats smaller numbers as better)
}
\description{
Calculate a tree's Profile Parsimony score with a given dataset, after Faith and Trueman (2001)
}
\section{Functions}{
\itemize{
\item \code{IWScoreMorphy}: Scorer for initialized dataset.

\item \code{ProfileScoreMorphy}: Scorer for initialized dataset.

\item \code{ProfileInitMorphy}: Initialize dataset by adding morphyObjs.

\item \code{ProfileDestroyMorphy}: Free memory from morphyObjs initialized by
\kbd{ProfileScoreMorphy}.
}}

\examples{
  data(referenceTree)
  data(congreveLamsdellMatrices)
  # In actual use, the dataset should be prepared with a much higher
  # precision: try 1e+06?
  # Of course, gaining higher precision takes substantially longer.
  dataset <- PrepareDataProfile(congreveLamsdellMatrices[[42]], precision=1e+03)
  ProfileScore(referenceTree, dataset)

}
\references{
\insertRef{Faith2001}{TreeSearch}
}
\author{
Martin R. Smith
}
\keyword{tree}
