% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sectorial.R
\name{Sectorial}
\alias{Sectorial}
\title{Sectorial Search}
\usage{
Sectorial(tree, dataset, TreeScorer = FitchScore,
  sectRearrangements = list(RootedNNI),
  searchRearrangements = list(RootedNNI, RootedTBR, RootedNNI),
  maxHits = c(30, 40, 60), maxIter = 2000, verbosity = 3, ...)
}
\arguments{
\item{tree}{a rooted, resolved tree in \code{\link{phylo}} format from which to start the search;}

\item{dataset}{A phylogenetic data matrix of class \code{\link[phangorn]{phyDat}}, whose names 
correspond to the labels of any accompanying tree}

\item{TreeScorer}{function by which trees should be scored; default \code{\link{FitchScore}}}

\item{sectRearrangements}{A list of functions to be applied when rearranging trees in sectorial 
search. Note: these must retain the position of the root of the tree}

\item{searchRearrangements}{A list of functions to be applied, in turn, during tree search.
Default: \code{list(\link{RootedTBR}, \link{RootedNNI})}}

\item{maxHits}{maximum number of hits to accomplish on each search iteration - provide a list or vector 
with each entry corresponding to an entry in Rearrangements, or a single entry to be used for all}

\item{maxIter}{maximum number of rearrangements to perform on each search iteration - provide a list or vector 
with each entry corresponding to an entry in Rearrangements, or a single entry to be used for all}

\item{verbosity}{verbosity of output written to terminal; higher values print more messages}

\item{\dots}{further arguments to pass to \code{TreeScorer} function (e.g. \code{\link{TipsAreColumns}}, \code{dataset})}
}
\value{
a rooted tree of class \code{phylo}.
}
\description{
\code{Sectorial} performs a sectorial search on a tree, preserving the position of the root.
}
\details{
\code{DoSectorial} performs a sectorial search on the tree specified. A sectorial search 
detaches a random part of the tree, performs rearrangements on this subtree, then reattaches it 
to the main tree (Goloboff, 1999).
The improvement to local \var{score} hopefully (but not necessarily) improves the overall \var{score}.
As such, the output of \code{DoSectorial} should be treated by further \acronym{TBR (/SPR/NNI)}
rearrangements and only retained if the ultimate parsimony score is better than 
that of the original tree.

NOTE. This function is not fully implemented, or tested; it may not work for many datasets.  It's on the TODO list.

\code{Sectorial} is a basic recipe that runs \code{DoSectorial} followed by a few rounds
of tree rearrangement, returning a tree whose \var{pscore} is no worse than that of \code{start.tree}.
}
\examples{
data('Lobo')
startTree <- RandomTree(Lobo.phy, 'Cricocosmia') # Position of root will be fixed
\dontrun{firstEstimate <- Sectorial(startTree, Lobo.phy, maxIter=50, verbosity=5)}
\dontrun{Sectorial(firstEstimate, Lobo.phy,
         sectRearrangements=list(RootedNNI, RootedTBR, RootedNNI)) # Will be time-consuming}

}
\references{
Goloboff, P. (1999). \cite{Analyzing large data sets in reasonable times: solutions for composite optima.}
Cladistics, 15(4), 415-428. doi:\href{http://dx.doi.org/10.1006/clad.1999.0122}{10.1006/clad.1999.0122}
}
\seealso{
\code{\link{TreeSearch}}

\code{\link{Ratchet}}
}
\author{
Martin R. Smith
}
\keyword{tree}
