% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{stemSegmentation}
\alias{stemSegmentation}
\title{Stem segmentation}
\usage{
stemSegmentation(las, method = sgt.ransac.circle())
}
\arguments{
\item{las}{\code{\link[lidR:LAS]{LAS}} object.}

\item{method}{stem segmentation algorithm. Currently available: \code{\link{sgt.ransac.circle}}, \code{\link{sgt.ransac.cylinder}}, \code{\link{sgt.irls.circle}}, \code{\link{sgt.irls.cylinder}} and \code{\link{sgt.bf.cylinder}}.}
}
\value{
signed \code{data.table} of stem segments.
}
\description{
Measure stem segments from a point cloud with assigned stem points. Stem segmentation methods are prefixed by \code{sgt}.
}
\details{
All stem segmentation algorithms return estimations for every stem \code{Segment} of every \code{TreeID}
(if the input \code{LAS} has multiple trees). For more details and a list of all outputs for each method check
the sections below.
}
\section{Random Sample Consensus (RANSAC) Algorithm}{


\loadmathjax

The \strong{RAN}dom \strong{SA}mple \strong{C}onsensus algorithm is a method that relies on resampling 
a data set as many times as necessary to find a subset comprised of only inliers - e.g. observations
belonging to a desired model. The RANSAC algorithm provides a way of estimating the necessary number of
iterations necessary to fit a model using inliers only, at least once, as shown in the equation:
\mjdeqn{k = log(1 - p) / log(1 - w^{n})}{k = log(1 - p) / log(1 - w^n)}
where:
\itemize{
\item \emph{k}: number of iterations
\item \emph{p}: confidence level, i.e. desired probability of success 
\item \emph{w}: proportion of inliers expected in the \emph{full} dataset
\item \emph{n}: number of observations sampled on every iteration
}

The models reiterated in \emph{TreeLS} usually relate to circle or cylinder 
fitting over a set of 3D coordinates, selecting the best possible model through the RANSAC algorithm

For more information, checkout \href{https://en.wikipedia.org/wiki/Random_sample_consensus}{this wikipedia page}.
}

\section{Iterative Reweighted Least Squares (IRLS) Algorithm}{


\emph{irls} \code{circle} or \code{cylinder} estimation methods 
perform automatic outlier assigning through iterative reweighting
with M-estimators, followed by a Nelder-Mead optimization of squared distance sums
to determine the best circle/cylinder parameters for a given point
cloud. The reweighting strategy used in \emph{TreeLS} is based on 
Liang et al. (2012). The Nelder-Mead algorithm implemented in Rcpp was provided by 
\href{https://github.com/kthohr/optim}{kthohr/optim}.
}

\section{Least Squares Circle Fit}{


The circle fit methods applied in \emph{TreeLS} estimate the circle parameters (its center's XY coordinates and radius)
from a pre-selected (denoised) set of points in a least squares fashion
by applying either \href{https://en.wikipedia.org/wiki/QR_decomposition}{QR decompostion}, used in combination
with the RANSAC algorithm, or \href{https://en.wikipedia.org/wiki/Nelder-Mead_method}{Nelder-Mead simplex}
optimization combined the IRLS approach.

The parameters returned by the circle fit methods are:
\itemize{
   \item \code{X,Y}: 2D circle center coordinates
   \item \code{Radius}: 2D circle radius, in point cloud units
   \item \code{Error}: model circle error from the least squares fit
   \item \code{AvgHeight}: average height of the stem segment's points
   \item \code{N}: number of points belonging to the stem segment
 }
}

\section{Least Squares Cylinder Fit}{


\loadmathjax

The cylinder fit methods implemented in \emph{TreeLS} estimate a 3D
cylinder`s axis direction and radius. The algorithm used internally
to optimize the cylinder parameters is the
\href{https://en.wikipedia.org/wiki/Nelder-Mead_method}{Nelder-Mead simplex},
which takes as objective function the model describing the distance from any point
to a modelled cylinder`s surface on a regular 3D cylinder point cloud:

\mjdeqn{D_{p} = |(p - q) \times a| - r}{Dp = abs((p - q) x a) - r}

where:

\itemize{
   \item \emph{Dp}: distance from a point to the model cylinder`s surface
   \item \emph{p}: a point on the cylinder`s surface
   \item \emph{q}: a point on the cylinder`s axis
   \item \emph{a}: unit vector of cylinder`s direction
   \item \emph{r}: cylinder`s radius
}

The Nelder-Mead algorithm minimizes the sum of squared \emph{Dp} from
a set of points belonging to a stem segment - in the context of \emph{TreeLS}.

The parameters returned by the cylinder fit methods are:
\itemize{
   \item \code{rho,theta,phi,alpha}: 3D cylinder estimated axis parameters (Liang et al. 2012)
   \item \code{Radius}: 3D cylinder radius, in point cloud units
   \item \code{Error}: model cylinder error from the least squares fit
   \item \code{AvgHeight}: average height of the stem segment's points
   \item \code{N}: number of points belonging to the stem segment
   \item \code{PX,PY,PZ}: absolute center positions of the stem segment points, in point cloud units (used for plotting)
 }
}

\section{Brute Force Cylinder Fit}{


The brute force cylinder fit approach estimates the axis rotation
angles by brute force combined with 2D ransac circle fit. The coordinates
of a point cloud representing a single cylinder are iteratively rotated up
to a pre defined threshold, and for every iteration a circle is estimated after
rotation is performed. The rotation that minimizes the circle parameters the most
is used to describe the axis direction of the cylinder with the circle's radius.

The parameters returned by the brute force cylinder fit method are:
\itemize{
   \item \code{X,Y}: 2D circle center coordinates after rotation
   \item \code{Radius}: 3D circle radius, in point cloud units
   \item \code{Error}: model circle error from the RANSAC least squares fit, after rotation
   \item \code{DX,DY}: absolute rotation angles (in degrees) applied to the X and Y axes, respectively
   \item \code{AvgHeight}: average height of the stem segment's points
   \item \code{N}: number of points belonging to the stem segment
 }
}

\examples{
\donttest{
file = system.file("extdata", "pine.laz", package="TreeLS")
tls = readTLS(file) \%>\%
  tlsNormalize

tls = stemPoints(tls, stm.hough())
sgt = stemSegmentation(tls, sgt.ransac.circle(n=20))
tlsPlot(tls, sgt)
}
}
\references{
Liang, X. et al., 2012. Automatic stem mapping using single-scan terrestrial laser scanning. IEEE Transactions on Geoscience and Remote Sensing, 50(2), pp.661–670.

Olofsson, K., Holmgren, J. & Olsson, H., 2014. Tree stem and height measurements using terrestrial laser scanning and the RANSAC algorithm. Remote Sensing, 6(5), pp.4323–4344.

Conto, T. et al., 2017. Performance of stem denoising and stem modelling algorithms on single tree point clouds from terrestrial laser scanning. Computers and Electronics in Agriculture, v. 143, p. 165-176.
}
