% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{nnFilter}
\alias{nnFilter}
\title{Nearest neighborhood point filter}
\usage{
nnFilter(las, d = 0.05, n = 2)
}
\arguments{
\item{las}{\code{\link[lidR:LAS]{LAS}} object.}

\item{d}{\code{numeric} - search radius.}

\item{n}{\code{numeric} - number of neighbors within \code{d} distance a point must have to be kept in the output.}
}
\value{
\code{\link[lidR:LAS]{LAS}} object.
}
\description{
Remove isolated points from a \code{LAS} point cloud based on their neighborhood distances.
}
\examples{
file = system.file("extdata", "spruce.laz", package="TreeLS")
tls = readTLS(file)
nrow(tls@data)

nn_tls = nnFilter(tls, 0.05, 3)
nrow(nn_tls@data)
}
