% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InputHandler.R
\name{InputHandler}
\alias{InputHandler}
\title{InputHandler}
\description{
Class to handle input from the user. Supports direct paths or input fields
through \code{setDataPath()}.\cr\cr
}
\section{Super class}{
\code{TreatmentPatterns::Module} -> \code{InputHandler}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{reactiveValues}}{(\code{reactiveValues})\cr
reactiveValues class created by \link[shiny]{reactiveValues}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-InputHandler-uiMenu}{\code{InputHandler$uiMenu()}}
\item \href{#method-InputHandler-uiBody}{\code{InputHandler$uiBody()}}
\item \href{#method-InputHandler-server}{\code{InputHandler$server()}}
\item \href{#method-InputHandler-uiDatabaseSelector}{\code{InputHandler$uiDatabaseSelector()}}
\item \href{#method-InputHandler-setDataPath}{\code{InputHandler$setDataPath()}}
\item \href{#method-InputHandler-clone}{\code{InputHandler$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="TreatmentPatterns" data-topic="Module" data-id="initialize"><a href='../../TreatmentPatterns/html/Module.html#method-Module-initialize'><code>TreatmentPatterns::Module$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="TreatmentPatterns" data-topic="Module" data-id="validate"><a href='../../TreatmentPatterns/html/Module.html#method-Module-validate'><code>TreatmentPatterns::Module$validate()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InputHandler-uiMenu"></a>}}
\if{latex}{\out{\hypertarget{method-InputHandler-uiMenu}{}}}
\subsection{Method \code{uiMenu()}}{
Method to include a \link[shinydashboard]{menuItem} to link to the body.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InputHandler$uiMenu(label = "File upload", tag = "fileUpload")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{label}}{(\code{character(1)})\cr
Label to show for the \code{menuItem}.}

\item{\code{tag}}{(\code{character(1)})\cr
Tag to use internally in \code{input}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(\code{menuItem})
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InputHandler-uiBody"></a>}}
\if{latex}{\out{\hypertarget{method-InputHandler-uiBody}{}}}
\subsection{Method \code{uiBody()}}{
Method to include a \link[shinydashboard]{tabItem} to include the body.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InputHandler$uiBody()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\code{tabItem})
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InputHandler-server"></a>}}
\if{latex}{\out{\hypertarget{method-InputHandler-server}{}}}
\subsection{Method \code{server()}}{
Method to handle the back-end.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InputHandler$server(input, output, session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{(\code{input})\cr
Input from the server function.}

\item{\code{output}}{(\code{output})\cr
Output from the server function.}

\item{\code{session}}{(\code{session})\cr
Session from the server function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(\code{NULL})
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InputHandler-uiDatabaseSelector"></a>}}
\if{latex}{\out{\hypertarget{method-InputHandler-uiDatabaseSelector}{}}}
\subsection{Method \code{uiDatabaseSelector()}}{
Method to include a \link[shiny]{uiOutput} to select between multiple
uploaded files.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InputHandler$uiDatabaseSelector()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\code{uiOutput})
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InputHandler-setDataPath"></a>}}
\if{latex}{\out{\hypertarget{method-InputHandler-setDataPath}{}}}
\subsection{Method \code{setDataPath()}}{
Method to dictate where the data is coming from, either from the \code{input}
through the shiny application, or from a specified path. When one is
provided, the other is ignored.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InputHandler$setDataPath(tag = "uploadField", input = NULL, path = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tag}}{(\code{character(1)})\cr
Tag to use internally in \code{input}.}

\item{\code{input}}{(\code{input})\cr
Input from the server function of the shiny app.}

\item{\code{path}}{(\code{character(1)})\cr
Path to a zip-file containing TreatmentPatterns output files.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(\code{invisible(self)})
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InputHandler-clone"></a>}}
\if{latex}{\out{\hypertarget{method-InputHandler-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InputHandler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
