% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans.local.DAG.R
\name{trans.local.DAG}
\alias{trans.local.DAG}
\title{Structural transfer learning of non-Gaussian DAG.}
\usage{
trans.local.DAG(t.data, A.data, hardth=0.5, hardth.A=hardth, criti.val=0.01,
                       precision.method="glasso", precision.method.A = "CLIME",
                       cov.method="opt", cn.lam2=seq(1,2.5,length.out=10),
                       precision.refit=TRUE, ini.prec=TRUE, cut.off=TRUE,
                       preselect.aux=0, sel.type="L2")
}
\arguments{
\item{t.data}{The target data, a n * p matrix, where n is the sample size and p is data dimension.}

\item{A.data}{The auxiliary data in K auxiliary domains, a list with K elements, each of which is a nk * p matrix, where nk is the sample size of the k-th auxiliary domain.}

\item{hardth}{The hard threshold of regression in the target domain.}

\item{hardth.A}{The hard threshold of regression in the auxiliary domains.}

\item{criti.val}{The critical value of independence test based on distance covariance, and the default setting is 0.01.}

\item{precision.method}{The initial method of estimating the target precision matrix, which can be selected as "CLIME" or "glasso".}

\item{precision.method.A}{The initial method of estimating the auxiliary precision matrices, which can be selected as "CLIME" or "glasso".}

\item{cov.method}{The method of aggregating K auxiliary covariance matrices, which can be selected as "size" (the sum weighted by the sample sizes), "weight" (the sum weighted by the differences), or "opt" (select the optimal one).}

\item{cn.lam2}{A vector or a float value: the coefficients set in tuning parameters used to solve the target precision matrix, default is cn.lam2*sqrt( log(p) / n ).}

\item{precision.refit}{Whether to perform regression for re-fitting the coefficients in the precision matrix to improve estimation accuracy, after determining the non-zero elements of the precision matrix. The default is True.}

\item{ini.prec}{Whether to store the initial estimation of the precision matrix, and the default is True.}

\item{cut.off}{Whether to truncate the finally estimated coefficients in the structural equation models at threshold "hardth", and the default is True.}

\item{preselect.aux}{Whether to pre-select informative auxiliary domains based on the distance between initially estimated auxiliary and target parameters. The default is 0, which means that pre-selection will not be performed. If "preselect.aux" is specified as a real number greater than zero, then the threshold value is forpreselect.aux\emph{s}sqrt( log(p) / n ).}

\item{sel.type}{If pre-selection should be performed, "sel.type" is the type of distance. The default is L2 norm, and can be specified as "L1" to use L1 norm.}
}
\value{
A result list including:
\describe{
\item{A}{The information of layer.}
\item{B}{The coefficients in structural equation models.}
\item{prec.res0}{The results about estimating the prscision matrix via transfer learning.}
\item{prec.res0$Theta.hat}{The estimated prscision matrix via transfer learning.}
\item{prec.res0$Theta.hat0}{The estimated prscision matrix based on the target domain only.}
}
}
\description{
Structural transfer learning of non-Gaussian DAG.
}
\examples{
\donttest{
library(TransGraph)
# load example data from github repository
# Please refer to https://github.com/Ren-Mingyang/example_data_TransGraph
# for detailed data information
githublink = "https://github.com/Ren-Mingyang/example_data_TransGraph/"
load(url(paste0(githublink,"raw/main/example.data.DAG.RData")))
t.data = example.data.DAG$target.DAG.data$X
true_adjace = example.data.DAG$target.DAG.data$true_adjace
A.data = example.data.DAG$auxiliary.DAG.data$X.list.A

# transfer method
res.trans = trans.local.DAG(t.data, A.data)
# Topological Layer method-based single-task learning (JLMR, 2022)
res.single = TLLiNGAM(t.data)

Evaluation.DAG(res.trans$B, true_adjace)$Eval_result
Evaluation.DAG(res.single$B, true_adjace)$Eval_result
}


}
\references{
Ren, M., He X., and Wang J. (2022). Transfer learning for tensor graphical models.
}
\author{
Mingyang Ren \href{mailto:renmingyang17@mails.ucas.ac.cn}{renmingyang17@mails.ucas.ac.cn}, Xin He, and Junhui Wang
}
