% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-refactor-data.R
\name{process_fishing_trips}
\alias{process_fishing_trips}
\title{Process fishing trip data from PRODUCE sitrapesca files}
\usage{
process_fishing_trips(data_fishing_trips, verbose = FALSE)
}
\arguments{
\item{data_fishing_trips}{Data frame with raw fishing trip data.}

\item{verbose}{Logical. Print column mapping information.}
}
\value{
Data frame with 6 standardized columns including trip code, vessel
information, and trip dates.
}
\description{
Processes fishing trip data from PRODUCE logbooks. Automatically detects
required columns and creates standardized output with proper date conversion.
}
\examples{
fishing_trips <- process_fishing_trips(data_fishing_trips = faenas_bitacora)
fishing_trips <- process_fishing_trips(data_fishing_trips = faenas_bitacora, verbose = TRUE)

}
