% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts.seasonal.decomp.R
\name{ts.seasonal.decomp}
\alias{ts.seasonal.decomp}
\title{Decomposition of seasonal time series}
\usage{
ts.seasonal.decomp(tsdata, tojson=F)
}
\arguments{
\item{tsdata}{The input univariate seasonal time series data}

\item{tojson}{If TRUE the results are returned in json format, default returns a list}
}
\value{
A list with the following components:
\itemize{
\item stl.plot: 
\itemize{
 \item trend: The estimated trend component
 \item seasonal: The estimated seasonal component
 \item remainder: The estimated remainder component
 \item time: The time of the series was sampled}

\item stl.general:
\itemize{
 \item model.summary The summary object of the arima model to use in forecast if needed
 \item stl.win: An integer vector of length 3 indicating the spans used for the "s", "t", and "l" smoothers
 \item stl.degree: An integer vector of length 3 indicating the polynomial degrees for these smoothers}
 
\item residuals_fitted: 
\itemize{
\item residuals: The residuals of the model (fitted innovations)
\item fitted: The model's fitted values
\item time the time of tsdata
\item line The y=0 line} 

\item compare: 
 \itemize{
 \item arima.order: The Arima order
 \item arima.coef: A vector of AR, MA and regression coefficients
 \item arima.coef.se: The standard error of the coefficients
 \item covariance.coef: The matrix of the estimated variance of the coefficients
 \item resid.variance: The MLE of the innovations variance
 \item not.used.obs: The number of not used observations for the fitting
 \item used.obs: the number of used observations for the fitting
 \item loglik: The maximized log-likelihood (of the differenced data), or the approximation to it used
 \item aic: The AIC value corresponding to the log-likelihood
 \item bic: The BIC value corresponding to the log-likelihood
 \item aicc: The second-order Akaike Information Criterion corresponding to the log-likelihood}}
}
\description{
Decomposition of seasonal time series data using stlm from forecast package. 
This function is used internally in ts.analysis.
}
\details{
Decomposition of seasonal time series data through arima models is based on stlm from forecast package
and returns a list with useful parameters for OBEU.
}
\references{
add
}
\seealso{
\code{\link{ts.analysis}}, \code{\link[forecast]{stlm}}
}
\author{
Kleanthis Koupidis
}
