% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw_gen.R
\name{raw_gen}
\alias{raw_gen}
\title{Raw Data Generation By Normal Or Truncated Normal Distribution}
\usage{
raw_gen(
  x,
  Trait = 1,
  Pop = 2,
  R.res = NULL,
  lower = -Inf,
  upper = Inf,
  verbose = FALSE
)
}
\arguments{
\item{x}{Data frame or list containing summary statistics for
multiple parameters measured in both sexes in two or more populations.}

\item{Trait}{Number of the column containing names of measured parameters,
Default: 1}

\item{Pop}{Number of the column containing populations' names, Default: 2}

\item{R.res}{Pooled within correlation matrix, Default: NULL}

\item{lower}{scalar of lower bounds, Default: -Inf}

\item{upper}{scalar of upper bounds, Default: Inf}

\item{verbose}{Logical; if TRUE displays a message with the method used for
generation , Default: FALSE}
}
\value{
a data frame of raw data
}
\description{
Generates raw data from summary statistics using
uni/multivariate truncated normal distribution
}
\details{
If data generation is desired using multivariate distribution data
is entered in the form of a list of summary statistics and pooled within
correlation matrix as in \link{baboon.parms_list}, or the summary
 statistics are entered separately in the form of a data frame as in
\link{baboon.parms_df} with a separate correlation matrix as in
\link{baboon.parms_R}. If data frame is entered without a correlation
matrix, data generation is carried out using univariate distribution.
}
\examples{
# Data generation using univariate distributions
raw_gen(baboon.parms_df, lower = 0)

# another univariate example
raw_gen(Cremains_measurements[1, ])[, -2]

# Data generation using multivariate distribution
raw_gen(baboon.parms_list, lower = 0)
}
