% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_sum.R
\name{extract_sum}
\alias{extract_sum}
\title{extract_sum}
\usage{
extract_sum(x, Sex = 1, Pop = 2, firstX = 3, test = 1,
  run = TRUE, pairwise = FALSE, padjust = "none",
  lower_tail = FALSE, pairwise_tail = "two")
}
\arguments{
\item{x}{Data frame containing raw data.}

\item{Sex}{Number of the column containing gender (\code{M} for male and
\code{F} for female), Default: \code{1}.}

\item{Pop}{Number of the column containing populations' names, Default: \code{2}.}

\item{firstX}{Number of the first column containing measured parameters,
Default: \code{3}.}

\item{test}{\code{1} for Greene t-test \code{Tg}, \code{2} for
\code{univariate}, \code{3} for sex specific ANOVA \code{aovSS}, \code{4}
for \code{multivariate} and \code{5} for \code{pMatrix}, Default: \code{1}.}

\item{run}{Logical;if \code{TRUE} runs the corresponding test after data
extraction, Default: \code{TRUE}.}

\item{pairwise}{Logical;if TRUE runs multiple comparisons after multi or
univariate analysis, Default: FALSE.}

\item{padjust}{Method of p value adjustment for multiple comparisons
following \code{p.adjust.methods}, Default: \code{'none'}.}

\item{lower_tail}{Logical; if TRUE probabilities are \code{P[X <= x]},
otherwise, \code{P[X > x]}, Default: \code{FALSE}.}

\item{pairwise_tail}{Number of t-test tails, Default: \code{'two'}.}
}
\value{
Input for other functions using raw data.
}
\description{
Extract summary data needed for other functions from raw data.
}
\details{
Raw data is entered as a data frame with the first two columns
  containing gender \code{Sex} (\code{M} for male and \code{F} for female)
  (Default: \code{1}) and populations' names \code{Pop} (Default: \code{2}).
  Starting from \code{firstX} column (Default: \code{3}), measured parameters
  are entered each in a separate column.
}
\examples{
# for multivariate test
TestDimorph::extract_sum(Howells)
# for univariate test on a specific parameter
TestDimorph::extract_sum(Howells, test = 2)

}
