% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpp_core_documents.r, R/RcppExports.R
\name{j_item}
\alias{j_item}
\alias{j_1pl}
\alias{j_2pl}
\alias{j_3pl}
\alias{j_pc}
\alias{j_gpc}
\alias{j_gr}
\alias{array_j_1pl}
\alias{array_j_2pl}
\alias{array_j_3pl}
\alias{array_j_pc}
\alias{array_j_gpc}
\alias{array_j_gr}
\title{(C++) Calculate first derivative of log-likelihood}
\usage{
j_1pl(x, b, u)

j_2pl(x, a, b, u)

j_3pl(x, a, b, c, u)

j_pc(x, b, u)

j_gpc(x, a, b, u)

j_gr(x, a, b, u)

array_j_1pl(x, b, u)

array_j_2pl(x, a, b, u)

array_j_3pl(x, a, b, c, u)

array_j_pc(x, b, u)

array_j_gpc(x, a, b, u)

array_j_gr(x, a, b, u)
}
\arguments{
\item{x}{the theta value. This must be a column vector in matrix form for \code{array_j_*()} functions.}

\item{u}{the response value.}

\item{a, b, c}{the item parameters.}
}
\description{
\code{j_*()} and \code{array_j_*()} are C++ functions for calculating the first derivative of the log-likelihood function.
}
\details{
\code{j_*()} functions accept a single theta value, and \code{array_j_*()} functions accept multiple theta values.

Currently supports unidimensional models.

\itemize{
  \item{\code{j_1pl()}, \code{array_j_1pl()}}: 1PL models
  \item{\code{j_2pl()}, \code{array_j_2pl()}}: 2PL models
  \item{\code{j_3pl()}, \code{array_j_3pl()}}: 3PL models
  \item{\code{j_pc()}, \code{array_j_pc()}}: PC (partial credit) models
  \item{\code{j_gpc()}, \code{array_j_gpc()}}: GPC (generalized partial credit) models
  \item{\code{j_gr()}, \code{array_j_gr()}}: GR (graded response) models
}
}
\examples{
u <- 1

x <- 0.5
j_1pl(x, 1, u)
j_2pl(x, 1, 2, u)
j_3pl(x, 1, 2, 0.25, u)
j_pc(x, c(0, 1), u)
j_gpc(x, 2, c(0, 1), u)
j_gr(x, 2, c(0, 2), u)

x <- matrix(seq(-3, 3, 1)) # column vector in matrix form
array_j_1pl(x, 1, u)
array_j_2pl(x, 1, 2, u)
array_j_3pl(x, 1, 2, 0.25, u)
array_j_pc(x, c(0, 1), u)
array_j_gpc(x, 2, c(0, 1), u)
array_j_gr(x, 2, c(0, 2), u)

}
\references{
Rasch, G. (1960). \emph{Probabilistic models for some intelligence and attainment tests.}
Copenhagen: Danish Institute for Educational Research.

Lord, F. M. (1952). A theory of test scores (Psychometric Monograph No. 7). Richmond, VA: Psychometric Corporation.

Birnbaum, A. (1957). \emph{Efficient design and use of tests of mental ability for various decision-making problems}
(Series Report No. 58-16. Project No. 7755-23).
Randolph Air Force Base, TX: USAF School of Aviation Medicine.

Birnbaum, A. (1958). \emph{On the estimation of mental ability}
(Series Report No. 15. Project No. 7755-23).
Randolph Air Force Base, TX: USAF School of Aviation Medicine.

Birnbaum, A. (1958). \emph{Further considerations of efficiency in tests of a mental ability}
(Series Report No. 17. Project No. 7755-23).
Randolph Air Force Base, TX: USAF School of Aviation Medicine.

Birnbaum, A. (1968). Some latent trait models and their use in inferring an examinee's ability.
In Lord, F. M., Novick, M. R. (eds.), \emph{Statistical Theories of Mental Test Scores}, 397-479.
Reading, MA: Addison-Wesley.

Masters, G. N. (1982). A Rasch model for partial credit scoring.
\emph{Psychometrika, 47}(2), 149-174.

Andrich, D. (1978). A rating formulation for ordered response categories.
\emph{Psychometrika, 43}(4), 561-573.

Muraki, E. (1992). A generalized partial credit model: Application of an EM algorithm.
\emph{Applied Psychological Measurement, 16}(2), 159-176.

Samejima, F. (1969). Estimation of latent ability using a response pattern of graded scores.
\emph{Psychometrika Monograph, 17}.
}
