% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MC_CRUDE.R
\name{MC_CRUDE}
\alias{MC_CRUDE}
\title{Crude MonteCarlo Simulation}
\usage{
MC_CRUDE(
  lsf,
  lDistr,
  cov_user = 0.025,
  n_batch = 100,
  n_max = 1e+07,
  use_threads = 64,
  dataRecord = TRUE,
  debug.level = 0
)
}
\arguments{
\item{lsf}{objective function with limit state function in form of function(x) {x[1]+x[2]...}}

\item{lDistr}{list ob distribiutions regarding the distribution object of TesiproV}

\item{cov_user}{The Coefficent of variation the simulation should reach}

\item{n_batch}{Size per batch for parallel computing}

\item{n_max}{maximum of iteration the MC should do - its like a stop criterion}

\item{use_threads}{TRUE for parallel computing, false for single core}

\item{dataRecord}{If True all single steps are recorded and available in the results file after on}

\item{debug.level}{If 0 no additional info if 2 high output during calculation}
}
\value{
The results will be provided within a list with the following objects. Acess them with "$"-accessor

pf probablity of failure

pf_FORM probablity of failure of the FORM Algorithm

var variation

cov_mc coefficent of the monteCarlo

n_mc number of iterations done
}
\description{
Method to calculate failure probability for structural engineering
}
\references{
Spaethe, G.: Die Sicherheit tragender Baukonstruktionen, 2. Aufl. Wien: Springer, 1991. – ISBN 3-211-82348-4
}
\author{
(C) 2021 - M. Ricker, K. Nille-Hauf, T. Feiri - Hochschule Biberach, Institut fuer Konstruktiven Ingenieurbau
}
