% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.tsglm.R
\name{summary.tsglm}
\alias{summary.tsglm}
\title{Summarizing Second-order Tensor Generalized Regression Fits}
\usage{
\method{summary}{tsglm}(object, ...)
}
\arguments{
\item{object}{an object of class \kbd{"tsglm"}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
\kbd{summary.tsglm} returns a printout similar to \code{\link[stats]{summary.glm}}.

The printout contains the following components:

\kbd{Call}: The formula for fitted model.

\kbd{Deviance Residuals}: The summary statistics of deviance residuals. Provide for model
except \kbd{family = "gaussian"}.

\kbd{Residuals}: The summary statistics of residuals. Provide for \kbd{family = "gaussian"}.

\kbd{Coefficients}: The coefficient table includes estimation, standard deviation,
test statistics, and p-value of parameters and significance stars.

\kbd{Deviance}: The deviance of a fitted model. Provide for model except \kbd{family = "gaussian"}.

\kbd{AIC}: Akaike information criterion.
}
\description{
\kbd{summary} method for self-defined class \kbd{"tsglm"}.
}
\details{
\kbd{summary.tsglm} is combined with \code{\link[base]{print}} to provide
formatting the coefficients, standard errors, etc. and additionally gives 'significance stars'
}
\examples{
# Predefined function: sum of hadamard product in each array
`\%i\%` <- function(X, B) sapply(1:dim(X)[3], function(i) sum(X[,,i]*B))

# Simulation data
n <- 1000 # number of observations
n_P <- 3; n_G <- 64 # dimension of 3-D tensor variables.
n_d <- 1 # number of numerical variable, if n_d == 1,  numerical variable equals to intercept.
beta_True <- rep(1, n_d)
B_True <- c(1,1,1)\%*\%t(rnorm(n_G)) + c(0, .5, .5)\%*\%t(rnorm(n_G))
B_True <- B_True / 10
W <- matrix(rnorm(n*n_d), n, n_d); W[,1] <- 1
X <- array(rnorm(n*n_P*n_G), dim=c(n_P, n_G, n))
## Regression
y_R<- as.vector(W\%*\%beta_True + X\%i\%B_True + rnorm(n))
DATA_R <- list(y = y_R, X = X, W = W)
## Binomial
p_B <- exp(W\%*\%beta_True + X\%i\%B_True); p_B <- p_B/(1+p_B)
y_B <- rbinom(n, 1, p_B)
DATA_B <- list(y = y_B, W = W, X = X)
## Poisson
p_P <- exp(W\%*\%beta_True + X\%i\%B_True)
y_P <- rpois(n, p_P)
y_P[which(y_P > 170)] <- 170 # If y_P > 170, factorial(y_P) == inf.
DATA_P <- list(y = y_P, W = W, X = X)

# Execution
## Regression
result_R <- TRtest.omics(y = DATA_R$y, X = DATA_R$X, W=NULL, n_R = 1, family = "gaussian",
opt = 1, max_ite = 100, tol = 10^(-7) )
summary(result_R)

## Binomial
result_B <- TRtest.omics(y = DATA_B$y, X = DATA_B$X, W=NULL, n_R = 1, family = "binomial",
opt = 1, max_ite = 100, tol = 10^(-7) )
summary(result_B)

## Poisson
result_P <- TRtest.omics(y = DATA_P$y, X = DATA_P$X, W=NULL, n_R = 1, family = "poisson",
opt = 1, max_ite = 100, tol = 10^(-7) )
summary(result_P)


}
\seealso{
\code{\link[base]{summary}}
}
\author{
Mark Chen
}
