% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tprAssortment.r
\name{tprAssortment}
\alias{tprAssortment}
\alias{tprAssortment,tprTrees-method}
\title{Functions to calculate assortments for given tree}
\usage{
tprAssortment(obj, pars = NULL, mono = TRUE, Rfn = NULL)

\S4method{tprAssortment}{tprTrees}(obj, pars = NULL, mono = TRUE, Rfn = NULL)
}
\arguments{
\item{obj}{an object of class 'tprTrees'}

\item{pars}{parameters to specify assortments, see \code{\link{parSort}}}

\item{mono}{logical, defaults to true. If calibrated taper curve is
non-monotonic at stem base, a support diameter is added.}

\item{Rfn}{Rfn setting for residuals error matrix, defaults to
\code{list(fn="sig2")}, see \code{\link[TapeR]{resVar}}.}
}
\value{
a data.frame with columns \code{tree}: tree identifier,
\code{sort}: assortment name, \code{height}: beginning of assortment along
trunk, \code{length}: length of assortment, \code{mdm}: mid-diameter of
assortment, \code{zdm}: top-diameter of assortment and \code{vol}: volume.
}
\description{
Function calculates assortments for given tree according to
assortment specification
}
\section{Methods (by class)}{
\itemize{
\item \code{tprAssortment(tprTrees)}: method for class 'tprTrees'

}}
\examples{
## conifer wood
obj <- tprTrees(spp=c(1, 8),
                Dm=list(30, 40),
                Hm=list(1.3, 1.3),
                Ht=c(30, 40))
tprAssortment(obj)
pars <- parSort(stH=0.2, Lxh=c(1, 1.5), fixN=2, fixL=4)
(ass <- tprAssortment(obj, pars))
plot(obj, assort = ass)

## deciduous wood
obj <- tprTrees(spp=c(15),
                Dm=list(40),
                Hm=list(1.3),
                Ht=c(40))
tprAssortment(obj)
pars <- parSort(n=length(obj), Lxh=c(1), Hsh=10, Az=10)
ass <- tprAssortment(obj, pars)
plot(obj, assort=ass)

}
