% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VPR_BFAST.R
\name{VPR.BFAST}
\alias{VPR.BFAST}
\title{BFAST Breakpoint Detector}
\usage{
VPR.BFAST(CTSR.VI, CTSR.RF, season = "none")
}
\arguments{
\item{CTSR.VI}{Complete Monthly Time Series of Vegetation Index values.
An object of class \code{'ts'} object without NA's.}

\item{CTSR.RF}{Complete Time Series of Rainfall. An object of class 'ts' object without NA's
and be the same length and cover the same time range as CTSR.VI.
If ACU.table is provided, CTSR.RF will be automitaclly calculated using the
\code{\link{ACP.calculator}}}

\item{season}{See \code{\link[bfast]{bfast}}}
}
\value{
List of objects:

\bold{bkps}
         The index of the Breakpoints detected. If no breakpoints are detected, bkps = FASLE

\bold{BFAST.obj}
         See \code{\link[bfast]{bfast}}

\bold{CTS.lm}
         the \code{\link[stats]{lm}} of CTSR.VI and CTSR.RF
}
\description{
Uses the Complete VI and Rainfall time series, calculates a \code{\link[stats]{lm}} between them
     And then performs a \code{\link[bfast]{bfast}}
}
\examples{
VPRBFdem <- VPR.BFAST(segVPRCTSR$cts.NDVI, segVPRCTSR$cts.precip)
print(VPRBFdem)
}
\author{
Arden Burrell, arden.burrell@unsw.edu.au
}

