% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsqca_ots_dts.R
\name{dtSweep}
\alias{dtSweep}
\title{DTS–QCA: Two-dimensional X–Y threshold sweep}
\usage{
dtSweep(
  dat,
  outcome = NULL,
  conditions = NULL,
  sweep_list_X,
  sweep_range_Y,
  dir.exp = NULL,
  include = "?",
  incl.cut = 0.8,
  n.cut = 1,
  pri.cut = 0,
  extract_mode = c("first", "all", "essential"),
  return_details = TRUE,
  Yvar = NULL,
  Xvars = NULL
)
}
\arguments{
\item{dat}{Data frame containing the outcome and condition variables.}

\item{outcome}{Character. Outcome variable name. Supports negation with
tilde prefix (e.g., \code{"~Y"}) following QCA package conventions.}

\item{conditions}{Character vector. Names of condition variables.}

\item{sweep_list_X}{Named list. Each element is a numeric vector of
candidate thresholds for the corresponding X.}

\item{sweep_range_Y}{Numeric vector. Candidate thresholds for Y.}

\item{dir.exp}{Directional expectations for \code{minimize}.
If \code{NULL}, all set to 1.}

\item{include}{Inclusion rule for \code{minimize}.}

\item{incl.cut}{Consistency cutoff for \code{truthTable}.}

\item{n.cut}{Frequency cutoff for \code{truthTable}.}

\item{pri.cut}{PRI cutoff for \code{minimize}.}

\item{extract_mode}{Character. How to handle multiple solutions:
\code{"first"} (default), \code{"all"}, or \code{"essential"}.
See \code{\link{qca_extract}} for details.}

\item{return_details}{Logical. If \code{TRUE} (default), returns both
summary and detailed objects for use with \code{generate_report()}.}

\item{Yvar}{Deprecated. Use \code{outcome} instead.}

\item{Xvars}{Deprecated. Use \code{conditions} instead.}
}
\value{
If \code{return_details = FALSE}, a data frame with columns:
\itemize{
\item \code{combo_id} — index of threshold combination
\item \code{thrY} — threshold for Y
\item \code{thrX} — character summary of X thresholds
\item \code{expression} — minimized solution expression
\item \code{inclS} — solution consistency
\item \code{covS} — solution coverage
\item (additional columns depending on \code{extract_mode})
}

If \code{return_details = TRUE}, a list with:
\itemize{
\item \code{summary} — the data frame above
\item \code{details} — list of runs with
\code{combo_id}, \code{thrY}, \code{thrX_vec},
\code{truth_table}, \code{solution}
}
}
\description{
Sweeps thresholds for multiple X variables and the outcome Y jointly.
For each combination of X thresholds and each candidate Y threshold, the
data are binarized and a crisp-set QCA is executed.
}
\examples{
# Load sample data
data(sample_data)

# Quick demonstration with reduced complexity (< 5 seconds)
# Using 2 conditions and 2 threshold levels
sweep_list_X <- list(
  X1 = 6:7,  # Reduced from 6:8 to 6:7
  X2 = 6:7   # Reduced from 6:8 to 6:7
)

sweep_range_Y <- 6:7  # Reduced from 6:8 to 6:7

# Run dual threshold sweep with reduced parameters
# This explores 2 × 2^2 = 8 threshold combinations
result_quick <- dtSweep(
  dat = sample_data,
  outcome = "Y",
  conditions = c("X1", "X2"),  # Reduced from 3 to 2 conditions
  sweep_list_X = sweep_list_X,
  sweep_range_Y = sweep_range_Y
)
head(result_quick$summary)

\donttest{
# Full analysis with all conditions and thresholds
# This explores 3 × 3^3 = 81 threshold combinations (takes ~10-15 seconds)
sweep_list_X_full <- list(
  X1 = 6:8,
  X2 = 6:8,
  X3 = 6:8
)

sweep_range_Y_full <- 6:8

result_full <- dtSweep(
  dat = sample_data,
  outcome = "Y",
  conditions = c("X1", "X2", "X3"),
  sweep_list_X = sweep_list_X_full,
  sweep_range_Y = sweep_range_Y_full
)

# Analyze threshold-dependent causal structures
head(result_full$summary)
}
}
