% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/TSMining.R
\name{Func.motif}
\alias{Func.motif}
\title{A function implementing the univaraite motif discovery algorithm using random projection}
\usage{
Func.motif(ts, global.norm, local.norm, window.size, overlap, w, a, mask.size,
  eps = 0.1, iter = 25, max.dist.ratio = 1.2, count.ratio.1 = 1.5,
  count.ratio.2 = 1.2)
}
\arguments{
\item{ts}{is a numeric vector representing the univarate time series}

\item{global.norm}{is a logical value specifying whether global standardization should be used for the whole time series}

\item{local.norm}{is a logical value specifying whether local standardization should be used for each subsequences}

\item{window.size}{is a integer which defines the length of the sliding window used to create subsequences}

\item{overlap}{is a numeric value ranging from 0 to 1. It defines the percentage of overlapping when using sliding window to create subsquences. 0 means subsequences are created without overlaps. 1 means subsequences are created with the maximum overlap possible.}

\item{w}{is an integer which defines the word size used for SAX transformation}

\item{a}{is an integer which defines the alphabet size used for SAX transformation}

\item{mask.size}{is the mask size used for random projection. It should be an integer ranging from 1 to the word size w}

\item{eps}{is the minimum threshold for variance in subsequence and should be a numeric value. If the subsequence considered has a smaller variance than eps, it will be represented as a word using the middle alphabet. The default value is 0.1}

\item{iter}{is an integer which specifies the iteration number in random projection, default value is 25}

\item{max.dist.ratio}{is a numeric value used to add other possible members to a motif candidate. Default value is 1.2. Each motif candidate has two subsequences. The distance between these two candidates are calculated as a baseline, denoted as BASE. Any subsequence, whose distance to the motif candidate is smaller than max.dist.ratio*BASE, is considered as a member of that motif candidate.}

\item{count.ratio.1}{defines the ratio between the iteration number and the minimum value in the collision matrix to be considered as motif candidate. Default value is 1.5. For instance, if the iter is 100, any pair of subsequence, which results in a value larger than 67 in the collision matrix, is considered as a motif candidate.}

\item{count.ratio.2}{defines the ratio between the maximum counts in  the collision matrix and any other count values that will be considered as potential members to a motif candidate}
}
\value{
The function returns a list of 6 elements. The first element is Subs, which is a data frame containing all the subsequences in original data formatThe second element is Subs.SAX, which is a data frame containing all the subsequences in SAX representations. The third element is Motif.raw, which is a list showing the motifs discovered in original data format.The fourth element is Motif.SAX, which is a list showing the motifs discovered in SAX representations. The fifth element is Collision.matrix, which is matrix containing the results of random projection. The sixth element is Indices, which is a list showing the starting positions of subsequences for each motif discovered.
}
\description{
The function implements the univariate motif discovery algorithm proposed in B. Chiu, E. Keogh, S. Lonardi. Probabilistic discovery of time series motifs. ACM SIGKDD, Washington, DC, USA, 2003, pp. 493-498.
}
\examples{
#Perform the motif discovery for the first time series in the example data
data(test)
res.1 <- Func.motif(ts = test$TS1, global.norm = TRUE, local.norm = FALSE,
window.size = 10, overlap = 0, w = 5, a = 3, mask.size = 3, eps = .01)
#Check the number of motifs discovered
length(res.1$Indices)
#Check the starting positions of subsequences of each motif discovered
res.1$Indices
}

