% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cal.data}
\alias{cal.data}
\title{Calibration Measurements}
\format{
Provides a data.frame with 4024 rows and 10 columns.
\describe{
  \item{Study}{Study from which the data originates (see Flo et al. 2019) (\code{character})}
  \item{Method}{Heat-based sap flow measurement method (TD = Thermal Dissipation) (\code{character})}
  \item{Genus}{Monitored genus (\code{character})}
  \item{Species}{Monitored species (\code{character})}
  \item{Calibration.material}{Description on the calibration method that was used,
        including stem segment, whole plant and whole plant without roots (\code{character})}
  \item{Wood.porosity}{Wood structure type of the examined species, including coniferous, diffuse-porous, ring-porous and monocots (\code{character})}
  \item{Diameter}{Diameter at breast height of the calibration subject (in cm) (\code{numeric})}
  \item{k}{Proportional difference between \eqn{\Delta T} and \eqn{\Delta T_{max}}{\Delta Tmax} measured
         by the thermal dissipation probes (unitless; \code{numeric})}
  \item{SFD}{Sap flux density measured gravimetrically (in \eqn{cm^3 cm^{-2} h^{-1}}{cm3 cm-2 h-1}; \code{numeric})}
  \item{Granier}{Sap flux density calculated according to Granier et al. 1985 using k
       (in \eqn{cm^3 cm^{-2} h^{-1}}{cm3 cm-2 h-1}; using \eqn{43.84 k^{1.231}}{k^1.231}) (\code{numeric})}
}
}
\usage{
cal.data
}
\description{
Returns raw calibration experiment data obtained from literature,
 with \emph{K} values combined with gravimetrically determined sap flux density,
 as detailed in Flo \emph{et al.} (2019).
 The \code{data.frame} contains 22 studies with 37 different species. The data is used
 within the \code{\link{tdm_cal.sfd}} function to calculate sap flux density.
 Description on the genus, species, calibration material, wood porosity and diameter
 of the stem is provided in Flo \emph{et al.} (2019).
 The presented data is open for public use.
}
\details{
Currently included studies are given below; individual labels (quoted) can be applied in \code{\link{tdm_cal.sfd}} (argument "study"):

\itemize{
    \item{Braun and Schmid 1999}
    \item{Cabibel et al. 1991}
    \item{Cain 2009}
    \item{Chan 2015}
    \item{Fuchs et al. 2017}
    \item{Granier 1985}
    \item{Gutierrez & Santiago 2005}
    \item{Herbst et al. 2007}
    \item{Liu et al. 2008}
    \item{Lu 2002}
    \item{Lu and Chacko 1998}
    \item{Oliveira et al. 2006}
    \item{Paudel et al. 2013}
    \item{Rubilar et al. 2016}
    \item{Schmidt-walter et al. 2014}
    \item{Sperling et al. 2012}
    \item{Sugiura et al. 2009}
    \item{Sun et al. 2012}
    \item{Vellame et al. 2009}
    \item{Hubbard et al. 2010}
    \item{Peters et al. 2017}
    \item{Steppe et al. 2010}

}
}
\references{
Flo V, Martinez-Vilalta J, Steppe K, Schuldt B, Poyatos, R. 2019.
A synthesis of bias and uncertainty in sap flow methods.
Agricultural and Forest Meteorology 271:362-374. \doi{10.1016/j.agrformet.2019.03.012}

Granier A. 1985. Une nouvelle methode pour la measure du flux de seve brute dans le tronc des arbres.
Annales des Sciences Forestieres 42:193–200. \doi{10.1051/forest:19850204}
}
\keyword{datasets}
