% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.Tenv.R
\name{predict.Tenv}
\alias{predict.Tenv}
\title{Predict method for TRR and TPR.}
\usage{
\method{predict}{Tenv}(object, newdata, ...)
}
\arguments{
\item{object}{An object of class "Tenv", as from \code{\link{TPR}} or \code{\link{TRR}}.}

\item{newdata}{The data to be used for prediction. It can be vector, matrix or tensor for \code{\link{TRR}} fits, and can be matrix
or tensor for \code{\link{TPR}} fits.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
\describe{
 \item{pred}{Predicted response.}
}
}
\description{
Predict response for object returned from \code{\link{TRR}} and \code{\link{TPR}} functions.
}
\examples{
data("bat")
Xn <- bat$Xn
Yn <- bat$Yn
fit <- TRR(Xn, Yn, method="standard")
predict(fit, Xn)
}
