% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rao.R
\name{Rao}
\alias{Rao}
\title{Rao's Quadratic Entropy and its Partition}
\usage{
Rao(diss = NULL, TPDc = NULL, regional = TRUE)
}
\arguments{
\item{diss}{An object of class "OverlapDiss", generated with the \code{\link{dissim}} function, containing the dissimilarity of the considered populations or species.}

\item{TPDc}{An object of class "TPDcomm", generated with the \code{\link{TPDc}} function, containing the containing the TPDc of all the communities whose functional diversity is going to be calculated. Species (or populations) identities and their relative abundance in each community will be extracted from this object.}

\item{regional}{Logical indicating if the correction by Villeger and Mouillot (2008) is applied or not. Defaults to TRUE.}
}
\value{
\code{Rao} returns a list containing functional diversity at different scales for the whole dataset and for pairs of communities.

   Information for the whole dataset include: i) alpha functional diversity of each sampling unit expressed as raw rao values (alpha_rao) and in equivalent numbers alpha_eqv), ii) the average alpha functional diversity of the sampling units, calculated following de Bello et al. (2010) (mean_alpha_eqv), iii) gamma functional diversity for the whole dataset, expressed as raw rao values (gamma_rao) and in equivalent numbers (gamma_eqv), and iv) beta functional diversity for the whole dataset expressed in proportional terms (see de Bello et al. 2010) (beta_prop).

   Information for pairs of communities (contained in the element pairwise) include the average alpha (expressed in equivalent numbers) of each pair of communities, gamma of each pair of communities and beta functional diversity for each pair of communities.
}
\description{
\code{Rao}
}
\examples{
# 1.  Compute the TPDs of three different species.
traits_iris <- iris[, c("Sepal.Length", "Sepal.Width")]
sp_iris <- iris$Species
TPDs_iris <- TPDs(species = sp_iris, traits_iris)
#2. Compute the dissimilarity between the three species:
dissim_iris_sp <- dissim(TPDs = TPDs_iris)
#3. Compute the TPDc of five different communities:
abundances_comm_iris <- matrix(c(c(0.9,  0.1, 0), # setosa dominates
                                 c(0.4,  0.5, 0.1 ),
                                 c(0.15, 0.7, 0.15), #versicolor dominates
                                 c(0.1,  0.5, 0.4),
                                 c(0,    0.1, 0.9)), #virginica dominates
                           ncol = 3, byrow = TRUE, dimnames = list(paste0("Comm.",1:5),
                             unique(iris$Species)))
TPDc_iris <- TPDc( TPDs = TPDs_iris, sampUnit = abundances_comm_iris)

#4. Compute Rao:
Rao_iris <- Rao(diss = dissim_iris_sp, TPDc = TPDc_iris)
}
