% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_plot.R
\name{pca_plot}
\alias{pca_plot}
\title{PCA dimensional reduction visualization for RNA-Seq.}
\usage{
pca_plot(
  pca_sample_gene,
  pca_group_sample,
  point_size = 5,
  text_size = 5,
  ellipse_alpha = 0.3,
  legend_pos = "right",
  legend_dir = "vertical",
  ggTheme = "theme_light"
)
}
\arguments{
\item{pca_sample_gene}{Dataframe: PCA data1 include samples and genes.}

\item{pca_group_sample}{Dataframe: PCA data2 include groups and samples.}

\item{point_size}{Numeric: PCA plot point size. Default: 5, min: 0.}

\item{text_size}{Numeric: PCA plot annotation size. Default: 5, min: 0.}

\item{ellipse_alpha}{Numeric: ellipse fill color alpha. Default: 0.30, min: 0.00, max: 1.00.}

\item{legend_pos}{Character: legend position. Default: "right", options: "none", "left", "right", "bottom", "top".}

\item{legend_dir}{Character: legend director. Default: "vertical", options: "horizontal", "vertical".}

\item{ggTheme}{Character: ggplot2 theme. Default: "theme_light", options: "theme_default", "theme_bw", "theme_gray", "theme_light", "theme_linedraw", "theme_dark", "theme_minimal", "theme_classic", "theme_void".}
}
\value{
Plot: PCA dimensional reduction visualization for RNA-Seq.
}
\description{
PCA dimensional reduction visualization for RNA-Seq.
}
\examples{
# 1. Library package TOmicsVis
library(TOmicsVis)

# 2. Load example datasets
data(pca_sample_gene)
data(pca_group_sample)

# 3. Default parameters
pca_plot(pca_sample_gene, pca_group_sample)

# 4. Set ellipse_alpha = 0.30
pca_plot(pca_sample_gene, pca_group_sample, ellipse_alpha = 0.00)

# 5. Set legend_pos = "right", legend_dir = "vertical"
pca_plot(pca_sample_gene, pca_group_sample, legend_pos = "top", legend_dir = "horizontal")

}
\author{
benben-miao
}
