
# This file is automatically generated, you probably don't want to edit this

dataTOSToneOptions <- if (requireNamespace('jmvcore')) R6::R6Class(
    "dataTOSToneOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            vars = NULL,
            mu = 0,
            low_eqbound = -0.5,
            high_eqbound = 0.5,
            eqbound_type = "d",
            alpha = 0.05,
            desc = FALSE,
            plots = FALSE,
            low_eqbound_d = -999999999,
            high_eqbound_d = -999999999, ...) {

            super$initialize(
                package='TOSTER',
                name='dataTOSTone',
                requiresData=TRUE,
                ...)

            private$..vars <- jmvcore::OptionVariables$new(
                "vars",
                vars,
                permitted=list(
                    "nominal",
                    "ordinal",
                    "continuous"),
                suggested=list(
                    "continuous"))
            private$..mu <- jmvcore::OptionNumber$new(
                "mu",
                mu,
                default=0)
            private$..low_eqbound <- jmvcore::OptionNumber$new(
                "low_eqbound",
                low_eqbound,
                default=-0.5)
            private$..high_eqbound <- jmvcore::OptionNumber$new(
                "high_eqbound",
                high_eqbound,
                default=0.5)
            private$..eqbound_type <- jmvcore::OptionList$new(
                "eqbound_type",
                eqbound_type,
                options=list(
                    "d",
                    "raw"),
                default="d")
            private$..alpha <- jmvcore::OptionNumber$new(
                "alpha",
                alpha,
                min=0,
                max=1,
                default=0.05)
            private$..desc <- jmvcore::OptionBool$new(
                "desc",
                desc,
                default=FALSE)
            private$..plots <- jmvcore::OptionBool$new(
                "plots",
                plots,
                default=FALSE)
            private$..low_eqbound_d <- jmvcore::OptionNumber$new(
                "low_eqbound_d",
                low_eqbound_d,
                hidden=TRUE,
                default=-999999999)
            private$..high_eqbound_d <- jmvcore::OptionNumber$new(
                "high_eqbound_d",
                high_eqbound_d,
                hidden=TRUE,
                default=-999999999)

            self$.addOption(private$..vars)
            self$.addOption(private$..mu)
            self$.addOption(private$..low_eqbound)
            self$.addOption(private$..high_eqbound)
            self$.addOption(private$..eqbound_type)
            self$.addOption(private$..alpha)
            self$.addOption(private$..desc)
            self$.addOption(private$..plots)
            self$.addOption(private$..low_eqbound_d)
            self$.addOption(private$..high_eqbound_d)
        }),
    active = list(
        vars = function() private$..vars$value,
        mu = function() private$..mu$value,
        low_eqbound = function() private$..low_eqbound$value,
        high_eqbound = function() private$..high_eqbound$value,
        eqbound_type = function() private$..eqbound_type$value,
        alpha = function() private$..alpha$value,
        desc = function() private$..desc$value,
        plots = function() private$..plots$value,
        low_eqbound_d = function() private$..low_eqbound_d$value,
        high_eqbound_d = function() private$..high_eqbound_d$value),
    private = list(
        ..vars = NA,
        ..mu = NA,
        ..low_eqbound = NA,
        ..high_eqbound = NA,
        ..eqbound_type = NA,
        ..alpha = NA,
        ..desc = NA,
        ..plots = NA,
        ..low_eqbound_d = NA,
        ..high_eqbound_d = NA)
)

dataTOSToneResults <- if (requireNamespace('jmvcore')) R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        tost = function() private$.items[["tost"]],
        eqb = function() private$.items[["eqb"]],
        desc = function() private$.items[["desc"]],
        plots = function() private$.items[["plots"]]),
    private = list(),
    public=list(
        initialize=function(options) {
            super$initialize(
                options=options,
                name="",
                title="TOST One Sample T-Test")
            self$add(jmvcore::Table$new(
                options=options,
                name="tost",
                title="TOST Results",
                rows="(vars)",
                clearWith=list(
                    "mu",
                    "alpha",
                    "var_equal",
                    "low_eqbound",
                    "high_eqbound",
                    "eqbound_type"),
                columns=list(
                    list(
                        `name`="var", 
                        `title`="", 
                        `type`="text", 
                        `content`="($key)"),
                    list(
                        `name`="b[0]", 
                        `title`="", 
                        `type`="text", 
                        `content`="t-test"),
                    list(
                        `name`="t[0]", 
                        `title`="t", 
                        `type`="number"),
                    list(
                        `name`="df[0]", 
                        `title`="df", 
                        `type`="integer"),
                    list(
                        `name`="p[0]", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue"),
                    list(
                        `name`="b[1]", 
                        `title`="", 
                        `type`="text", 
                        `content`="TOST Upper"),
                    list(
                        `name`="t[1]", 
                        `title`="t", 
                        `type`="number"),
                    list(
                        `name`="df[1]", 
                        `title`="df", 
                        `type`="integer"),
                    list(
                        `name`="p[1]", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue"),
                    list(
                        `name`="b[2]", 
                        `title`="", 
                        `type`="text", 
                        `content`="TOST Lower"),
                    list(
                        `name`="t[2]", 
                        `title`="t", 
                        `type`="number"),
                    list(
                        `name`="df[2]", 
                        `title`="df", 
                        `type`="integer"),
                    list(
                        `name`="p[2]", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue"))))
            self$add(jmvcore::Table$new(
                options=options,
                name="eqb",
                title="Equivalence Bounds",
                rows="(vars)",
                clearWith=list(
                    "mu",
                    "alpha",
                    "var_equal",
                    "low_eqbound",
                    "high_eqbound",
                    "eqbound_type"),
                columns=list(
                    list(
                        `name`="var", 
                        `title`="", 
                        `type`="text", 
                        `content`="($key)"),
                    list(
                        `name`="stat[cohen]", 
                        `title`="", 
                        `type`="text", 
                        `content`="Cohen's d"),
                    list(
                        `name`="low[cohen]", 
                        `title`="Low", 
                        `type`="number"),
                    list(
                        `name`="high[cohen]", 
                        `title`="High", 
                        `type`="number"),
                    list(
                        `name`="cil[cohen]", 
                        `title`="Lower", 
                        `superTitle`="Confidence interval", 
                        `content`=""),
                    list(
                        `name`="ciu[cohen]", 
                        `title`="Upper", 
                        `superTitle`="Confidence interval", 
                        `content`=""),
                    list(
                        `name`="stat[raw]", 
                        `title`="", 
                        `type`="text", 
                        `content`="Raw"),
                    list(
                        `name`="low[raw]", 
                        `title`="Low", 
                        `type`="number"),
                    list(
                        `name`="high[raw]", 
                        `title`="High", 
                        `type`="number"),
                    list(
                        `name`="cil[raw]", 
                        `title`="Lower", 
                        `superTitle`="Confidence interval"),
                    list(
                        `name`="ciu[raw]", 
                        `title`="Upper", 
                        `superTitle`="Confidence interval"))))
            self$add(jmvcore::Table$new(
                options=options,
                name="desc",
                title="Descriptives",
                visible="(desc)",
                rows="(vars)",
                clearWith=NULL,
                columns=list(
                    list(
                        `name`="name", 
                        `title`="", 
                        `content`="($key)", 
                        `type`="text"),
                    list(
                        `name`="n", 
                        `title`="N", 
                        `type`="integer"),
                    list(
                        `name`="m", 
                        `title`="Mean", 
                        `type`="number"),
                    list(
                        `name`="med", 
                        `title`="Median", 
                        `type`="number"),
                    list(
                        `name`="sd", 
                        `title`="SD", 
                        `type`="number"),
                    list(
                        `name`="se", 
                        `title`="SE", 
                        `type`="number"))))
            self$add(jmvcore::Array$new(
                options=options,
                name="plots",
                title="Plots",
                items="(vars)",
                visible="(plots)",
                template=jmvcore::Image$new(
                    options=options,
                    title="$key",
                    renderFun=".plot",
                    width=180,
                    clearWith=list(
                        "mu",
                        "alpha",
                        "var_equal",
                        "low_eqbound",
                        "high_eqbound",
                        "eqbound_type"))))}))

dataTOSToneBase <- if (requireNamespace('jmvcore')) R6::R6Class(
    "dataTOSToneBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'TOSTER',
                name = 'dataTOSTone',
                version = c(1,0,0),
                options = options,
                results = dataTOSToneResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = FALSE)
        }))

#' TOST One Sample T-Test
#'
#' TOST One Sample T-Test
#'
#' @examples
#' library("TOSTER")
#'
#' dataTOSTone(data=iris, vars="Sepal.Width", mu=3, low_eqbound=-0.3, high_eqbound=0.3,
#'             alpha=0.05, desc=TRUE, plots=TRUE)
#'
#' TOSTone(m=3.05733, mu=3, sd=0.4358663, n=150, low_eqbound_d=-0.3, high_eqbound_d=0.3, alpha=0.05)
#'
#' @param data the data as a data frame
#' @param vars a vector of strings naming variables of interest in \code{data}
#' @param mu a number (default: 0) to compare against
#' @param low_eqbound a number (default: -0.5) the lower equivalence bounds
#' @param high_eqbound a number (default: 0.5) the upper equivalence bounds
#' @param eqbound_type \code{'d'} (default) or \code{'raw'}; whether the
#'   bounds are specified in Cohen's d or raw units respectively
#' @param alpha alpha level (default = 0.05)
#' @param desc \code{TRUE} or \code{FALSE} (default), provide descriptive
#'   statistics
#' @param plots \code{TRUE} or \code{FALSE} (default), provide plots
#' @param low_eqbound_d deprecated
#' @param high_eqbound_d deprecated
#' @return A results object containing:
#' \tabular{llllll}{
#'   \code{results$tost} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$eqb} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$desc} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$plots} \tab \tab \tab \tab \tab an array of images \cr
#' }
#'
#' Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:
#'
#' \code{results$tost$asDF}
#'
#' \code{as.data.frame(results$tost)}
#'
#' @export
dataTOSTone <- function(
    data,
    vars,
    mu = 0,
    low_eqbound = -0.5,
    high_eqbound = 0.5,
    eqbound_type = "d",
    alpha = 0.05,
    desc = FALSE,
    plots = FALSE,
    low_eqbound_d = -999999999,
    high_eqbound_d = -999999999) {

    if ( ! requireNamespace('jmvcore'))
        stop('dataTOSTone requires jmvcore to be installed (restart may be required)')

    options <- dataTOSToneOptions$new(
        vars = vars,
        mu = mu,
        low_eqbound = low_eqbound,
        high_eqbound = high_eqbound,
        eqbound_type = eqbound_type,
        alpha = alpha,
        desc = desc,
        plots = plots,
        low_eqbound_d = low_eqbound_d,
        high_eqbound_d = high_eqbound_d)

    results <- dataTOSToneResults$new(
        options = options)

    analysis <- dataTOSToneClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}
