
# This file is automatically generated, you probably don't want to edit this

#' @importFrom jmvcore Options
#' @importFrom R6 R6Class
dataTOSTtwoOptions <- R6::R6Class(
    "dataTOSTtwoOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            deps = NULL,
            group = NULL,
            var_equal = FALSE,
            low_eqbound_d = -0.5,
            high_eqbound_d = 0.5,
            alpha = 0.05,
            desc = FALSE,
            plots = FALSE, ...) {

            super$initialize(
                package='TOSTER',
                name='dataTOSTtwo',
                requiresData=TRUE,
                ...)
        
            private$..deps <- jmvcore::OptionVariables$new(
                "deps",
                deps,
                permitted=list(
                    "nominal",
                    "ordinal",
                    "continuous"),
                suggested=list(
                    "continuous"))
            private$..group <- jmvcore::OptionVariable$new(
                "group",
                group,
                suggested=list(
                    "nominal",
                    "ordinal"))
            private$..var_equal <- jmvcore::OptionBool$new(
                "var_equal",
                var_equal,
                default=FALSE)
            private$..low_eqbound_d <- jmvcore::OptionNumber$new(
                "low_eqbound_d",
                low_eqbound_d,
                default=-0.5)
            private$..high_eqbound_d <- jmvcore::OptionNumber$new(
                "high_eqbound_d",
                high_eqbound_d,
                default=0.5)
            private$..alpha <- jmvcore::OptionNumber$new(
                "alpha",
                alpha,
                default=0.05)
            private$..desc <- jmvcore::OptionBool$new(
                "desc",
                desc,
                default=FALSE)
            private$..plots <- jmvcore::OptionBool$new(
                "plots",
                plots,
                default=FALSE)
        
            self$.addOption(private$..deps)
            self$.addOption(private$..group)
            self$.addOption(private$..var_equal)
            self$.addOption(private$..low_eqbound_d)
            self$.addOption(private$..high_eqbound_d)
            self$.addOption(private$..alpha)
            self$.addOption(private$..desc)
            self$.addOption(private$..plots)
        }),
    active = list(
        deps = function() private$..deps$value,
        group = function() private$..group$value,
        var_equal = function() private$..var_equal$value,
        low_eqbound_d = function() private$..low_eqbound_d$value,
        high_eqbound_d = function() private$..high_eqbound_d$value,
        alpha = function() private$..alpha$value,
        desc = function() private$..desc$value,
        plots = function() private$..plots$value),
    private = list(
        ..deps = NA,
        ..group = NA,
        ..var_equal = NA,
        ..low_eqbound_d = NA,
        ..high_eqbound_d = NA,
        ..alpha = NA,
        ..desc = NA,
        ..plots = NA)
)

#' @import jmvcore
#' @importFrom R6 R6Class
dataTOSTtwoResults <- R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        tost = function() private$..tost,
        eqb = function() private$..eqb,
        desc = function() private$..desc,
        plots = function() private$..plots),
    private = list(
        ..tost = NA,
        ..eqb = NA,
        ..desc = NA,
        ..plots = NA),
    public=list(
        initialize=function(options) {
            super$initialize(options=options, name="", title="TOST Independent Samples T-Test")
            private$..tost <- jmvcore::Table$new(
                options=options,
                name="tost",
                title="TOST Results",
                rows="(deps)",
                clearWith=list(
                    "group",
                    "alpha",
                    "low_eqbound_d",
                    "high_eqbound_d",
                    "var_equal"),
                columns=list(
                    list(`name`="var", `title`="", `type`="text", `content`="($key)"),
                    list(`name`="b[0]", `title`="", `type`="text", `content`="t-test"),
                    list(`name`="t[0]", `title`="t", `type`="number"),
                    list(`name`="df[0]", `title`="df", `type`="number"),
                    list(`name`="p[0]", `title`="p", `type`="number", `format`="zto,pvalue"),
                    list(`name`="b[1]", `title`="", `type`="text", `content`="TOST Upper"),
                    list(`name`="t[1]", `title`="t", `type`="number"),
                    list(`name`="df[1]", `title`="df", `type`="number"),
                    list(`name`="p[1]", `title`="p", `type`="number", `format`="zto,pvalue"),
                    list(`name`="b[2]", `title`="", `type`="text", `content`="TOST Lower"),
                    list(`name`="t[2]", `title`="t", `type`="number"),
                    list(`name`="df[2]", `title`="df", `type`="number"),
                    list(`name`="p[2]", `title`="p", `type`="number", `format`="zto,pvalue")))
            private$..eqb <- jmvcore::Table$new(
                options=options,
                name="eqb",
                title="Equivalence Bounds",
                rows="(deps)",
                clearWith=list(
                    "group",
                    "alpha",
                    "low_eqbound_d",
                    "high_eqbound_d",
                    "var_equal"),
                columns=list(
                    list(`name`="var", `title`="", `type`="text", `content`="($key)"),
                    list(`name`="stat[cohen]", `title`="", `type`="text", `content`="Cohen's d"),
                    list(`name`="low[cohen]", `title`="Low", `type`="number"),
                    list(`name`="high[cohen]", `title`="High", `type`="number"),
                    list(`name`="cil[cohen]", `title`="Lower", `superTitle`="Confidence interval", `content`=""),
                    list(`name`="ciu[cohen]", `title`="Upper", `superTitle`="Confidence interval", `content`=""),
                    list(`name`="stat[raw]", `title`="", `type`="text", `content`="Raw"),
                    list(`name`="low[raw]", `title`="Low", `type`="number"),
                    list(`name`="high[raw]", `title`="High", `type`="number"),
                    list(`name`="cil[raw]", `title`="Lower", `superTitle`="Confidence interval"),
                    list(`name`="ciu[raw]", `title`="Upper", `superTitle`="Confidence interval")))
            private$..desc <- jmvcore::Table$new(
                options=options,
                name="desc",
                title="Descriptives",
                visible="(desc)",
                rows="(deps)",
                clearWith=list(
                    "group"),
                columns=list(
                    list(`name`="name[1]", `title`="", `type`="text"),
                    list(`name`="n[1]", `title`="N", `type`="integer"),
                    list(`name`="m[1]", `title`="Mean", `type`="number"),
                    list(`name`="med[1]", `title`="Median", `type`="number"),
                    list(`name`="sd[1]", `title`="SD", `type`="number"),
                    list(`name`="se[1]", `title`="SE", `type`="number"),
                    list(`name`="name[2]", `title`="", `type`="text"),
                    list(`name`="n[2]", `title`="N", `type`="integer"),
                    list(`name`="m[2]", `title`="Mean", `type`="number"),
                    list(`name`="med[2]", `title`="Median", `type`="number"),
                    list(`name`="sd[2]", `title`="SD", `type`="number"),
                    list(`name`="se[2]", `title`="SE", `type`="number")))
            private$..plots <- jmvcore::Array$new(
                options=options,
                name="plots",
                title="Plots",
                items="(deps)",
                visible="(plots)",
                template=jmvcore::Image$new(
                    options=options,
                    title="$key",
                    renderFun=".plot",
                    width=180,
                    clearWith=list(
                        "group",
                        "alpha",
                        "low_eqbound_d",
                        "high_eqbound_d",
                        "var_equal")))
            self$add(private$..tost)
            self$add(private$..eqb)
            self$add(private$..desc)
            self$add(private$..plots)}))

#' @importFrom jmvcore Analysis
#' @importFrom R6 R6Class
dataTOSTtwoBase <- R6::R6Class(
    "dataTOSTtwoBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'TOSTER',
                name = 'dataTOSTtwo',
                version = c(1,0,0),
                options = options,
                results = dataTOSTtwoResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL)
        }))

#' TOST Independent Samples T-Test
#'
#' TOST Independent Samples T-Test
#'
#' @examples
#' library(TOSTER)
#' 
#' ## Load iris dataset, remove one of the three groups so two are left
#' 
#' data<-iris[which(iris$Species!="versicolor"),]
#' 
#' ## TOST procedure on the raw data
#' 
#' dataTOSTtwo(data, deps="Sepal.Width", group="Species", var_equal = TRUE, low_eqbound_d = -0.5,
#'             high_eqbound_d = 0.5, alpha = 0.05, desc = TRUE, plots = TRUE)
#' 
#' @section References:
#' Berger, R. L., & Hsu, J. C. (1996). Bioequivalence Trials, Intersection-Union Tests and Equivalence Confidence Sets. Statistical Science, 11(4), 283-302.
#'
#' Gruman, J. A., Cribbie, R. A., & Arpin-Cribbie, C. A. (2007). The effects of heteroscedasticity on tests of equivalence. Journal of Modern Applied Statistical Methods, 6(1), 133-140, formula for Welch's t-test on page 135
#'
#' @param data the data as a data frame
#' @param deps a vector of strings naming dependent variables in \code{data}
#' @param group a string naming the grouping variable in \code{data}; must 
#'   have two levels 
#' @param var_equal \code{TRUE} or \code{FALSE} (default), assume equal 
#'   variances 
#' @param low_eqbound_d lower equivalence bounds (e.g., -0.5) expressed in 
#'   standardized mean difference (Cohen's d) 
#' @param high_eqbound_d upper equivalence bounds (e.g., 0.5) expressed in 
#'   standardized mean difference (Cohen's d) 
#' @param alpha alpha level (default = 0.05)
#' @param desc \code{TRUE} or \code{FALSE} (default), provide descriptive 
#'   statistics 
#' @param plots \code{TRUE} or \code{FALSE} (default), provide plots 
#' @export
dataTOSTtwo <- function(
    data,
    deps,
    group,
    var_equal = FALSE,
    low_eqbound_d = -0.5,
    high_eqbound_d = 0.5,
    alpha = 0.05,
    desc = FALSE,
    plots = FALSE) {

    options <- dataTOSTtwoOptions$new(
        deps = deps,
        group = group,
        var_equal = var_equal,
        low_eqbound_d = low_eqbound_d,
        high_eqbound_d = high_eqbound_d,
        alpha = alpha,
        desc = desc,
        plots = plots)

    results <- dataTOSTtwoResults$new(
        options = options)

    analysis <- dataTOSTtwoClass$new(
        options = options,
        data = data)

    analysis$run()
    analysis$render()

    analysis$results
}
