% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regionalize.R
\name{regionalize}
\alias{regionalize}
\alias{regionalize.numeric}
\alias{regionalize.matrix}
\alias{regionalize.data.frame}
\alias{regionalize.list}
\title{Calculation of regionalized TL-moments}
\usage{
regionalize(x, ...)

\method{regionalize}{numeric}(x, ...)

\method{regionalize}{matrix}(x, w = attr(x, "source")$n,
  reg.lambdas = TRUE, ...)

\method{regionalize}{data.frame}(x, w = attr(x, "source")$n,
  reg.lambdas = TRUE, ...)

\method{regionalize}{list}(x, w = attr(x, "source")$n,
  reg.lambdas = TRUE, ...)
}
\arguments{
\item{x}{object returned by TLMoments.}

\item{...}{additional arguments, not used at the moment.}

\item{w}{numeric vector giving the weights. Default: Sample lengths of corresponding
data. Internally scaled so that it adds up to 1.}

\item{reg.lambdas}{logical, if TRUE (default) regionalization is
based upon TL-moments. If false it's based on TL-moment-ratios.}
}
\value{
list of two dimensions: \code{lambdas}/\code{ratios} are numeric vectors
consisting of the regionalized TL-moments/TL-moment-ratios. The list has
the class \code{TLMoments}. The object contains the following attributes: \itemize{
 \item \code{leftrim}: a numeric giving the used leftrim-argument
 \item \code{rightrim}: a numeric giving the used rightrim-argument
 \item \code{order}: a integer vector with corresponding TL-moment orders
 \item \code{source}: a list with background information (used function, data,
 n, formula, computation.method; mainly for internal purposes)
}
}
\description{
regionalize takes the result of TLMoments and calculates a weighted mean
of TL-moments and TL-moment ratios.
}
\examples{
xmat <- matrix(rgev(100), nc = 4)
xvec <- xmat[, 3]
xlist <- lapply(1L:ncol(xmat), function(i) xmat[, i])
xdat <- data.frame(
 station = rep(letters[1:2], each = 50),
 season = rep(c("S", "W"), 50),
 hq = as.vector(xmat)
)

regionalize(TLMoments(xmat))
regionalize(TLMoments(xlist))
regionalize(TLMoments(xdat, hq ~ station))
# For numeric vector TLMoments, nothing happens:
regionalize(TLMoments(xvec))

tlm <- TLMoments(xmat)
regionalize(tlm)
regionalize(tlm, reg.lambdas = FALSE)

parameters(regionalize(tlm), "gev")
parameters(regionalize(tlm, reg.lambdas = FALSE), "gev")

quantiles(parameters(regionalize(tlm), "gev"), c(.99, .999))
quantiles(parameters(regionalize(tlm, reg.lambdas = FALSE), "gev"), c(.99, .999))


# With magrittr
library(magrittr)
matrix(rgev(200, shape = .3), nc = 5) \%>\%
 TLMoments(rightrim = 1) \%>\%
 regionalize \%>\%
 parameters("gev") \%>\%
 quantiles(c(.99, .999))
}
