% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sumz_density.R
\name{plot_sumz_density}
\alias{plot_sumz_density}
\title{Plot community level change}
\usage{
plot_sumz_density(
  titan.out,
  filter = TRUE,
  sumz = TRUE,
  points = FALSE,
  ribbon = TRUE,
  density = TRUE,
  change_points = TRUE,
  sumz1 = TRUE,
  sumz2 = TRUE,
  xlim = c(min(titan.out$env), max(titan.out$envcls)),
  xlabel = "Environmental Gradient",
  y1label = NULL,
  y2label = "Density",
  alpha1 = 0.65,
  alpha2 = 0.5,
  col1 = "steelblue4",
  col2 = "red",
  trans = "identity",
  legend.position = c(0.9, 0.9),
  ...,
  axis.text.x,
  axis.text.y,
  axis.title.x,
  axis.title.y
)
}
\arguments{
\item{titan.out}{A TITAN output object.}

\item{filter}{A logical indicating whether only pure and reliable taxa should
be used to create the plot.This is the recommended as a check of the
unfiltered default to assess whether impure or unreliable taxa are
substantially contributing to the distribution of sum(z) scores.}

\item{sumz}{Plot sum z values? (Default = \code{TRUE})}

\item{points}{Plot points on sum z values? (Default = \code{FALSE})}

\item{ribbon}{Fill in axes under sum z values?  (Default = \code{TRUE})}

\item{density}{Plot densities of change points?  (Default = \code{TRUE})}

\item{change_points}{Plot ranges of change points? These are taken from the
titan object. (Default = \code{TRUE})}

\item{sumz1}{A logical specifying whether decreasing changes should be
plotted.}

\item{sumz2}{A logical specifying whether increasing changes should be
plotted.}

\item{xlim}{x axis limits, e.g. \code{xlim = c(0,10)}.}

\item{xlabel}{A character string for the x axis label.}

\item{y1label}{A character specifying the label of the second y axis}

\item{y2label}{A character specifying the label of the second y axis}

\item{alpha1, alpha2}{Transparency of Z- and Z+ values, respectively.}

\item{col1}{A graphical argument specifying the color of group 1 symbols.}

\item{col2}{A graphical argument specifying the color of group 2 symbols.}

\item{trans}{a scale transformation to be applied to the x-axis through
ggplot2. e.g. \code{"log10"} or \code{"sqrt"}.}

\item{legend.position}{ggplot2 legend position in relative coordinates of sum
z plot. (Default = \code{c(.9, .9)})}

\item{...}{An argument for passing generic plotting function parameters.}

\item{axis.text.x}{Font sizes of
respective axis text. Passed as the size argument to the ggplot2 thematic
elements of the same name. Defaults to current default ggplot2 theme.}

\item{axis.text.y}{Font sizes of
respective axis text. Passed as the size argument to the ggplot2 thematic
elements of the same name. Defaults to current default ggplot2 theme.}

\item{axis.title.x}{Font sizes of
respective axis text. Passed as the size argument to the ggplot2 thematic
elements of the same name. Defaults to current default ggplot2 theme.}

\item{axis.title.y}{Font sizes of
respective axis text. Passed as the size argument to the ggplot2 thematic
elements of the same name. Defaults to current default ggplot2 theme.}
}
\value{
A plot
}
\description{
Plot community level change
}
\note{
Should not be used with output objects from TITAN v1.0.
}
\examples{

data(glades.titan)

plot_sumz_density(glades.titan)
plot_sumz_density(glades.titan, trans = "log10")



}
\references{
Baker, ME and RS King.  2010. A new method for detecting and
interpreting biodiversity and ecological community thresholds.  Methods in
Ecology and Evolution 1(1): 25:37.

King, RS and ME Baker  2010. Considerations for identifying and
interpreting ecological community thresholds. Journal of the North American
Benthological Association 29(3):998-1008.
}
\seealso{
\code{\link[=plot_sumz]{plot_sumz()}}, \code{\link[=plot_cps]{plot_cps()}}
}
\author{
M. Baker and R. King
}
