% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_spatial_information.R
\name{extract_spatial_information}
\alias{extract_spatial_information}
\title{Extract distances and surface areas from a spatial object}
\usage{
extract_spatial_information(
  geometry,
  id = NULL,
  great_circle = FALSE,
  show_progress = FALSE
)
}
\arguments{
\item{geometry}{A spatial object that can be handled by the \code{sf} package.}

\item{id}{The name or number of the column to use as \code{rownames} and
\code{colnames} for the output distance \code{matrix} (optional, \code{NULL} by default). A
\code{vector} with a length equal to the number of locations can also be used.}

\item{great_circle}{A \code{boolean} indicating whether distances and surface
areas should be computed using longitude/latitude coordinates (see Details).}

\item{show_progress}{A \code{boolean} indicating whether a progress bar should be
displayed.}
}
\value{
A \code{list} composed of two elements. The first element is a square \code{matrix}
representing the great-circle distances (in kilometers) between locations.
The second element is a vector containing the surface area of each location
(in square kilometers).
}
\description{
This function returns a \code{matrix} of distances between locations (in
kilometers) along with a vector of surface areas for the locations (in square
kilometers).
}
\details{
The \code{geometry} must be projected in a valid coordinate reference system (CRS).
By default, if \code{great_circle = TRUE}, the coordinates will be reprojected in
degrees longitude/latitude to compute great-circle
distances between centroids using an internal function, and surface areas
will be
calculated using \code{\link[sf:geos_measures]{sf::st_area()}}. If \code{great_circle = FALSE}, the coordinates
are assumed to be planar (e.g., in meters) and Euclidean distances will
be used.
}
\note{
The outputs are based on the locations contained in \code{geometry} and
sorted in the same order. An optional \code{id} can also be provided to be used as
names for the outputs.
}
\examples{
data(county)

res <- extract_spatial_information(county, id = "ID")

dim(res$distance)

length(res$surface)

}
\seealso{
Associated functions:
\code{\link[=extract_distances]{extract_distances()}} \code{\link[=extract_opportunities]{extract_opportunities()}}
}
\author{
Maxime Lenormand (\email{maxime.lenormand@inrae.fr})
}
