% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxOR.R
\name{calculateCutoffs}
\alias{calculateCutoffs}
\title{Calculate data filtering results and two cutoffs for given sensitivity and specificity threshold}
\usage{
calculateCutoffs(dataC, seThreshold = 0.1, spThreshold = 0.1)
}
\arguments{
\item{dataC}{Data frame containing columns: se, sp, age, y0, OR, y}

\item{seThreshold}{Sensitivity threshold}

\item{spThreshold}{Specificity threshold}
}
\value{
A list with two elements: filteredData(the filtered dataset) and cutoffs(the calculated two cutoffs)
}
\description{
Calculate data filtering results and two cutoffs for given sensitivity and specificity threshold
}
\examples{
# Generate simulated data dataC
dataC <- createData(200)

# Fit the semi-parametric model
spm.fit <- fitSemiParamModel(dataC)

# Find two cut-off points
dataC <- findCutoffs(spm.fit, dataC)

# Output the two cut-off points after limiting sensitivity se and specificity sp
result <- calculateCutoffs(dataC)
cutoffs <- result$cutoffs
dataC2 <- result$filteredData
print(cutoffs)
}
